/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.model;

import de.alpharogroup.model.ChainingModel;
import de.alpharogroup.model.api.Model;
import de.alpharogroup.model.api.ObjectClassAware;
import de.alpharogroup.model.api.PropertyReflectionAwareModel;
import de.alpharogroup.model.property.PropertyResolver;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPropertyModel<T>
extends ChainingModel<T>
implements ObjectClassAware<T>,
PropertyReflectionAwareModel<T> {
    private static final long serialVersionUID = 1L;

    public AbstractPropertyModel(Object modelObject) {
        super(modelObject);
    }

    public final Object getInnermostModelOrObject() {
        Object tmp;
        Object object = this.getTarget();
        while (object instanceof Model && (tmp = ((Model)object).getObject()) != object) {
            object = tmp;
        }
        return object;
    }

    @Override
    public T getObject() {
        String expression = this.propertyExpression();
        if (StringUtils.isEmpty((CharSequence)expression)) {
            return (T)this.getInnermostModelOrObject();
        }
        if (expression.startsWith(".")) {
            throw new IllegalArgumentException("Property expressions cannot start with a '.' character");
        }
        Object target = this.getInnermostModelOrObject();
        if (target != null) {
            return this.getProperty(expression, target);
        }
        return null;
    }

    public Class<T> getObjectClass() {
        block8: {
            String expression = this.propertyExpression();
            Object target = this.getInnermostModelOrObject();
            if (StringUtils.isEmpty((CharSequence)expression)) {
                return target != null ? target.getClass() : null;
            }
            if (target != null) {
                try {
                    return PropertyUtils.getPropertyType((Object)target, (String)expression);
                }
                catch (Exception exception) {
                    break block8;
                }
            }
            if (this.getTarget() instanceof ObjectClassAware) {
                try {
                    Class targetClass = ((ObjectClassAware)this.getTarget()).getObjectClass();
                    if (targetClass != null) {
                        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(expression, targetClass);
                        return propertyDescriptor.getPropertyType();
                    }
                }
                catch (IntrospectionException introspectionException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private T getProperty(String expression, Object target) {
        Object property = null;
        property = PropertyResolver.getValue(expression, target);
        return (T)property;
    }

    public final String getPropertyExpression() {
        return this.propertyExpression();
    }

    public Field getPropertyField() {
        Object target;
        String expression = this.propertyExpression();
        if (!StringUtils.isEmpty((CharSequence)expression) && (target = this.getInnermostModelOrObject()) != null) {
            try {
                return target.getClass().getDeclaredField(expression);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Method getPropertyGetter() {
        Object target;
        String expression = this.propertyExpression();
        if (!StringUtils.isEmpty((CharSequence)expression) && (target = this.getInnermostModelOrObject()) != null) {
            try {
                Class<?> targetClass = target.getClass();
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor(expression, targetClass);
                return propertyDescriptor.getReadMethod();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Method getPropertySetter() {
        Object target;
        String expression = this.propertyExpression();
        if (!StringUtils.isEmpty((CharSequence)expression) && (target = this.getInnermostModelOrObject()) != null) {
            try {
                Class<?> targetClass = target.getClass();
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor(expression, targetClass);
                return propertyDescriptor.getWriteMethod();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected abstract String propertyExpression();

    @Override
    public void setObject(T object) {
        String expression = this.propertyExpression();
        if (StringUtils.isEmpty((CharSequence)expression)) {
            Object target = this.getTarget();
            if (target instanceof Model) {
                ((Model)target).setObject(object);
            } else {
                this.setTarget(object);
            }
        } else {
            Object target = this.getInnermostModelOrObject();
            if (target != null) {
                try {
                    PropertyUtils.setProperty((Object)target, (String)expression, object);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

