/*
 * Decompiled with CFR 0.152.
 */
package message.system.service;

import java.util.Map;
import javax.mail.MessagingException;
import message.system.application.models.InfoMessageModel;
import net.sourceforge.jaulp.email.messages.EmailMessage;
import net.sourceforge.jaulp.email.send.SendEmail;
import net.sourceforge.jaulp.email.utils.EmailUtils;
import net.sourceforge.jaulp.string.StringUtils;
import org.apache.log4j.Logger;

public class SendMessageBusinessService {
    private static final Logger LOGGER = Logger.getLogger((String)SendMessageBusinessService.class.getName());

    public static void sendInfoEmail(SendEmail emailSender, InfoMessageModel model) throws MessagingException {
        SendMessageBusinessService.sendInfoEmail(emailSender, model, null);
    }

    public static void sendInfoEmail(SendEmail emailSender, InfoMessageModel model, Map<String, String> emailHeaders) throws MessagingException {
        SendMessageBusinessService.sendEmail(emailSender, model.getApplicationSenderAddress(), model.getApplicationDomainName(), model.getRecipientEmailContact(), model.getRecipientFullName(), model.getMessageContentModel().getSubject(), model.getMessageContentModel().getContent(), emailHeaders);
    }

    public static void sendEmail(SendEmail emailSender, String senderEmail, String senderPersonal, String recipientEmail, String recipientPersonal, String subject, String content, Map<String, String> emailHeaders) throws MessagingException {
        EmailMessage emailMessage = new EmailMessage();
        EmailUtils.setFromToEmailMessage((String)senderEmail, (String)senderPersonal, (String)"UTF-8", (EmailMessage)emailMessage);
        EmailUtils.addToRecipientToEmailMessage((String)recipientEmail, (String)recipientPersonal, (String)"UTF-8", (EmailMessage)emailMessage);
        LOGGER.debug((Object)("Subject:" + subject));
        subject = StringUtils.removeNewlineCharacters((String)subject);
        emailMessage.setSubject(subject);
        LOGGER.debug((Object)("Content:" + content));
        emailMessage.setUtf8Content((Object)content);
        if (emailHeaders != null && !emailHeaders.isEmpty()) {
            for (Map.Entry<String, String> emailHeaderEntry : emailHeaders.entrySet()) {
                emailMessage.setHeader(emailHeaderEntry.getKey(), emailHeaderEntry.getValue());
            }
        }
        emailSender.sendEmailMessage(emailMessage);
    }
}

