/*
 * Decompiled with CFR 0.152.
 */
package message.system.service;

import hbm.dao.jpa.EntityManagerDao;
import hbm.service.jpa.AbstractBusinessService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Query;
import message.system.application.models.send.api.IBaseMessageModel;
import message.system.application.models.utlis.MessageModelConverter;
import message.system.daos.MessagesDao;
import message.system.enums.MessageState;
import message.system.enums.MessageType;
import message.system.factories.MessageSystemFactory;
import message.system.model.MessageRecipients;
import message.system.model.Messages;
import message.system.service.api.MessageRecipientsService;
import message.system.service.api.MessagesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import user.management.model.Users;
import user.management.service.api.UsersService;

@Transactional
@Service(value="messagesService")
public class MessagesBusinessService
extends AbstractBusinessService<Messages, Integer, MessagesDao>
implements MessagesService {
    private static final long serialVersionUID = 1L;
    @Autowired
    private MessageRecipientsService messageRecipientsService;
    @Autowired
    private UsersService usersService;

    @Autowired
    public void setMessagesDao(MessagesDao messagesDao) {
        this.setDao((EntityManagerDao)messagesDao);
    }

    @Override
    public List<Messages> findMessagesChildren(Messages parent) {
        String hqlString = "select distinct m from Messages as m where m.parent=:parent";
        Query query = this.getQuery("select distinct m from Messages as m where m.parent=:parent");
        query.setParameter("parent", (Object)parent);
        List messages = query.getResultList();
        if (null != messages && !messages.isEmpty()) {
            return messages;
        }
        return null;
    }

    @Override
    public List<Messages> findAllChildren(Messages parent) {
        List<Messages> children = this.findMessagesChildren(parent);
        ArrayList<Messages> childElements = new ArrayList<Messages>();
        childElements.addAll(children);
        if (children != null) {
            for (Messages child : children) {
                childElements.addAll(this.findAllChildren(child));
            }
        }
        return childElements;
    }

    @Override
    public List<Messages> findMessages(Users user) {
        String hqlString = "select distinct mr.message from MessageRecipients as mr where mr.recipient=:user and mr.message.recipientDeletedFlag=:recipientDeletedFlag ";
        Query query = this.getQuery("select distinct mr.message from MessageRecipients as mr where mr.recipient=:user and mr.message.recipientDeletedFlag=:recipientDeletedFlag ");
        query.setParameter("user", (Object)user);
        query.setParameter("recipientDeletedFlag", (Object)Boolean.FALSE);
        List messages = query.getResultList();
        return messages;
    }

    @Override
    public List<Messages> findMessages(Users user, MessageState state) {
        String hqlString = "select distinct mr.message from MessageRecipients as mr where mr.recipient=:user and mr.message.state=:state and mr.message.recipientDeletedFlag=:recipientDeletedFlag ";
        Query query = this.getQuery("select distinct mr.message from MessageRecipients as mr where mr.recipient=:user and mr.message.state=:state and mr.message.recipientDeletedFlag=:recipientDeletedFlag ");
        query.setParameter("user", (Object)user);
        query.setParameter("state", (Object)state);
        query.setParameter("recipientDeletedFlag", (Object)Boolean.FALSE);
        List messages = query.getResultList();
        return messages;
    }

    @Override
    public List<Messages> findSentMessages(Users user) {
        String hqlString = "select distinct m from Messages as m where m.sender=:user and m.senderDeletedFlag=:senderDeletedFlag";
        Query query = this.getQuery("select distinct m from Messages as m where m.sender=:user and m.senderDeletedFlag=:senderDeletedFlag");
        query.setParameter("user", (Object)user);
        query.setParameter("senderDeletedFlag", (Object)Boolean.FALSE);
        List messages = query.getResultList();
        return messages;
    }

    @Override
    public List<Messages> findReplyMessages(Users user) {
        String hqlString = "select distinct m from Messages as m where m.sender=:user and m.parent is not null and m.messagetype=:messagetype";
        Query query = this.getQuery("select distinct m from Messages as m where m.sender=:user and m.parent is not null and m.messagetype=:messagetype");
        query.setParameter("user", (Object)user);
        query.setParameter("messagetype", (Object)MessageType.REPLY);
        List messages = query.getResultList();
        return messages;
    }

    @Override
    public Messages saveMessageWithRecipients(IBaseMessageModel model) {
        if (model.getSendInformationModel().getSender() == null) {
            throw new IllegalArgumentException("Message should have a Sender. Currently Sender is null. Sender should not be null.");
        }
        if (model.getSendInformationModel().getRecipients() == null || model.getSendInformationModel().getRecipients().isEmpty()) {
            throw new IllegalArgumentException("Message should have recipients. Currently recipients is null or empty. At least one recipient should be set.");
        }
        Messages message = MessageModelConverter.createMessage(model);
        message = (Messages)this.merge(message);
        Set<Users> recipients = model.getSendInformationModel().getRecipients();
        for (Users recipient : recipients) {
            recipient = (Users)this.usersService.get(recipient.getId());
            MessageRecipients messageRecipient = MessageSystemFactory.getInstance().newMessageRecipients(message, recipient);
            this.messageRecipientsService.merge(messageRecipient);
        }
        return (Messages)this.merge(message);
    }

    @Override
    public Set<Users> getRecipients(Messages message) {
        String hqlString = "select mr.recipient from MessageRecipients mr where mr.message=:message";
        Query query = this.getQuery("select mr.recipient from MessageRecipients mr where mr.message=:message");
        query.setParameter("message", (Object)message);
        List recipients = query.getResultList();
        if (recipients != null && !recipients.isEmpty()) {
            return new HashSet<Users>(recipients);
        }
        return null;
    }

    @Override
    public boolean isRecipientFrom(Messages message, Users user) {
        Set<Users> recipients = this.getRecipients(message);
        return recipients != null && recipients.contains(user);
    }

    public MessageRecipientsService getMessageRecipientsService() {
        return this.messageRecipientsService;
    }

    public void setMessageRecipientsService(MessageRecipientsService messageRecipientsService) {
        this.messageRecipientsService = messageRecipientsService;
    }

    public UsersService getUsersService() {
        return this.usersService;
    }

    public void setUsersService(UsersService usersService) {
        this.usersService = usersService;
    }
}

