/*
 * Decompiled with CFR 0.152.
 */
package message.system.model;

import hbm.dao.postgres.usertype.PGEnumUserType;
import hbm.entity.BaseEntity;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import message.system.enums.MessageState;
import message.system.enums.MessageType;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;
import resource.system.model.Resources;
import user.management.model.Contactmethods;
import user.management.model.Users;

@Entity
@Table(name="messages")
@TypeDefs(value={@TypeDef(name="messagetypeConverter", typeClass=PGEnumUserType.class, parameters={@Parameter(name="enumClassName", value="message.system.enums.MessageType")}), @TypeDef(name="stateConverter", typeClass=PGEnumUserType.class, parameters={@Parameter(name="enumClassName", value="message.system.enums.MessageState")})})
public class Messages
extends BaseEntity<Integer>
implements Cloneable {
    private static final long serialVersionUID = 920286633675636537L;
    private Messages parent;
    private Boolean senderDeletedFlag;
    private Boolean recipientDeletedFlag;
    private Boolean failed2sentemail;
    private String folder;
    private String messageContent;
    private MessageType messagetype;
    private Boolean readFlag;
    private Users sender;
    private Contactmethods senderEmail;
    private Date sentDate;
    private Boolean spamFlag;
    private MessageState state;
    private String subject;
    private Set<Resources> attachments = new HashSet<Resources>();

    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="message_attachments", joinColumns={@JoinColumn(name="message_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="resource_id", referencedColumnName="id")})
    public Set<Resources> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Set<Resources> attachments) {
        this.attachments = attachments;
    }

    @Column(name="sender_deleted_flag")
    public Boolean isSenderDeletedFlag() {
        return this.senderDeletedFlag;
    }

    @Column(name="recipient_deleted_flag")
    public Boolean isRecipientDeletedFlag() {
        return this.recipientDeletedFlag;
    }

    public void setSenderDeletedFlag(Boolean deletedFlag) {
        this.senderDeletedFlag = deletedFlag;
    }

    public void setRecipientDeletedFlag(Boolean recipientDeletedFlag) {
        this.recipientDeletedFlag = recipientDeletedFlag;
    }

    public Boolean isFailed2sentemail() {
        return this.failed2sentemail;
    }

    public void setFailed2sentemail(Boolean failed2sentemail) {
        this.failed2sentemail = failed2sentemail;
    }

    @Column(length=64)
    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    @Column(length=21845)
    public String getMessageContent() {
        return this.messageContent;
    }

    public void setMessageContent(String messageContent) {
        this.messageContent = messageContent;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="messagetype")
    @Type(type="messagetypeConverter")
    public MessageType getMessagetype() {
        return this.messagetype;
    }

    public void setMessagetype(MessageType messagetype) {
        this.messagetype = messagetype;
    }

    @Column(name="read_flag")
    public Boolean isReadFlag() {
        return this.readFlag;
    }

    public void setReadFlag(Boolean readFlag) {
        this.readFlag = readFlag;
    }

    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="sender", nullable=true, referencedColumnName="id")
    @Index(name="IDX_SENDER")
    @ForeignKey(name="FK_MESSAGES_SENDER")
    public Users getSender() {
        return this.sender;
    }

    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="sender_email", nullable=true, referencedColumnName="id")
    @Index(name="IDX_SENDER_EMAIL")
    @ForeignKey(name="FK_MESSAGES_SENDER_EMAIL")
    public Contactmethods getSenderEmail() {
        return this.senderEmail;
    }

    public void setSenderEmail(Contactmethods senderEmail) {
        this.senderEmail = senderEmail;
    }

    public void setSender(Users sender) {
        this.sender = sender;
    }

    @Column(name="sent_date")
    public Date getSentDate() {
        return this.sentDate;
    }

    public void setSentDate(Date sentDate) {
        this.sentDate = sentDate;
    }

    @Column(name="spam_flag")
    public Boolean isSpamFlag() {
        return this.spamFlag;
    }

    public void setSpamFlag(Boolean spamFlag) {
        this.spamFlag = spamFlag;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="state")
    @Type(type="stateConverter")
    public MessageState getState() {
        return this.state;
    }

    public void setState(MessageState state) {
        this.state = state;
    }

    @Column(length=1000)
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    @OneToOne
    @JoinColumn(name="parent")
    @Index(name="IDX_PARENT_MESSAGE_ID")
    @ForeignKey(name="FK_PARENT_MESSAGE_ID")
    public Messages getParent() {
        return this.parent;
    }

    public void setParent(Messages parent) {
        this.parent = parent;
    }
}

