/*
 * Decompiled with CFR 0.152.
 */
package message.system.application.models.utlis;

import java.util.Date;
import message.system.application.models.BaseMessageModel;
import message.system.application.models.InfoMessageModel;
import message.system.application.models.ReplyMessageModel;
import message.system.application.models.send.MessageContentModel;
import message.system.application.models.send.SendInformationModel;
import message.system.application.models.send.SendMessagePanelModel;
import message.system.application.models.send.api.IBaseMessageModel;
import message.system.enums.MessageState;
import message.system.enums.MessageType;
import message.system.factories.MessageSystemFactory;
import message.system.model.MessageRecipients;
import message.system.model.Messages;
import user.management.model.Users;

public class MessageModelConverter {
    public static ReplyMessageModel convert(MessageRecipients messageRecipients) {
        ReplyMessageModel replyMessageModel = MessageModelConverter.convert(messageRecipients.getMessage());
        replyMessageModel.getSendInformationModel().addRecipient(messageRecipients.getRecipient());
        return replyMessageModel;
    }

    public static ReplyMessageModel convert(Messages message) {
        ReplyMessageModel replyMessageModel = new ReplyMessageModel();
        replyMessageModel.setSendInformationModel(new SendInformationModel());
        replyMessageModel.setMessageContentModel(new MessageContentModel());
        Users sender = message.getSender();
        replyMessageModel.getSendInformationModel().setSender(sender);
        replyMessageModel.getSendInformationModel().setSentDate(message.getSentDate());
        replyMessageModel.getMessageContentModel().setSubject(message.getSubject());
        replyMessageModel.getMessageContentModel().setContent(message.getMessageContent());
        replyMessageModel.setParent(message);
        return replyMessageModel;
    }

    public static Messages createMessage(IBaseMessageModel model) {
        Date sentDate = model.getSendInformationModel().getSentDate();
        if (sentDate == null) {
            sentDate = new Date(System.currentTimeMillis());
        }
        Messages message = MessageSystemFactory.getInstance().newMessages(false, false, "sent", model.getMessageContentModel().getContent(), model.getMessageType(), false, model.getSendInformationModel().getSender(), sentDate, false, model.getMessageState(), model.getMessageContentModel().getSubject());
        return message;
    }

    public static Messages createMessage(InfoMessageModel model, Users sender, Date sentDate) {
        String subject = model.getMessageContentModel().getSubject();
        String content = model.getMessageContentModel().getContent();
        Messages message = MessageSystemFactory.getInstance().newMessages(Boolean.FALSE, Boolean.FALSE, "sent", content, MessageType.MAIL, Boolean.FALSE, sender, sentDate, Boolean.FALSE, MessageState.UNREPLIED, subject);
        return message;
    }

    public static Messages createMessage(InfoMessageModel model, Users sender) {
        return MessageModelConverter.createMessage(model, sender, new Date(System.currentTimeMillis()));
    }

    public static Messages createReplyMessage(ReplyMessageModel model) {
        Date sentDate = model.getSendInformationModel().getSentDate();
        if (sentDate == null) {
            sentDate = new Date(System.currentTimeMillis());
        }
        Messages message = MessageSystemFactory.getInstance().newMessages(false, false, "sent", model.getMessageContentModel().getContent(), model.getMessageType(), false, model.getSendInformationModel().getSender(), sentDate, false, model.getMessageState(), model.getMessageContentModel().getSubject(), model.getParent());
        return message;
    }

    public static void synchronize(Messages message, BaseMessageModel model) {
        message.setMessageContent(model.getMessageContentModel().getContent());
        message.setMessagetype(model.getMessageType());
        message.setSender(model.getSendInformationModel().getSender());
        message.setSentDate(model.getSendInformationModel().getSentDate());
        message.setState(model.getMessageState());
        message.setSubject(model.getMessageContentModel().getSubject());
    }

    public static IBaseMessageModel createBaseMessageModel(SendMessagePanelModel model, Users sender, Users recipient) {
        BaseMessageModel baseMessageModel = new BaseMessageModel();
        MessageContentModel messageModel = new MessageContentModel();
        messageModel.setContent(model.getMessageContent());
        messageModel.setSubject(model.getSubject());
        baseMessageModel.setMessageContentModel(messageModel);
        SendInformationModel messageSendModel = new SendInformationModel();
        baseMessageModel.setSendInformationModel(messageSendModel);
        baseMessageModel.setMessageState(MessageState.UNREPLIED);
        baseMessageModel.setMessageType(MessageType.MAIL);
        baseMessageModel.getSendInformationModel().addRecipient(recipient);
        baseMessageModel.getSendInformationModel().setSender(sender);
        baseMessageModel.getSendInformationModel().setSentDate(new Date(System.currentTimeMillis()));
        return baseMessageModel;
    }
}

