/*
 * Decompiled with CFR 0.152.
 */
package message.system.application.models.utlis;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Map;
import message.system.application.models.send.MessageContentModel;
import message.system.application.models.send.api.IMessageContentModel;
import net.sourceforge.jaulp.file.read.ReadFileUtils;
import net.sourceforge.jaulp.lang.ClassUtils;
import net.sourceforge.jaulp.locale.LocaleUtils;
import net.sourceforge.jaulp.velocity.VelocityUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageComposer {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)MessageComposer.class.getName());

    public static IMessageContentModel createMessageModel(Map<String, Object> contextModel, String xmlMailTemplateName, Locale locale) throws IOException, ParseException, URISyntaxException {
        String localizedName = MessageComposer.getXmlMailTemplateName(xmlMailTemplateName, locale, false);
        IMessageContentModel xmlMailTemplate = MessageComposer.getEmailTemplate(localizedName);
        Template subjectTemplate = VelocityUtils.getTemplate((String)xmlMailTemplate.getSubject());
        Template contentTemplate = VelocityUtils.getTemplate((String)xmlMailTemplate.getContent());
        VelocityContext context = new VelocityContext(contextModel);
        StringWriter contentWriter = new StringWriter();
        contentTemplate.merge((Context)context, (Writer)contentWriter);
        StringWriter subjectWriter = new StringWriter();
        subjectTemplate.merge((Context)context, (Writer)subjectWriter);
        MessageContentModel result = new MessageContentModel();
        result.setSubject(subjectWriter.toString());
        result.setContent(contentWriter.toString());
        return result;
    }

    public static String getXmlMailTemplateName(String xmlMailTemplateName, Locale locale, boolean withCountry) {
        StringBuilder localizedName = new StringBuilder();
        localizedName.append(xmlMailTemplateName);
        localizedName.append(LocaleUtils.getLocaleFileSuffix((Locale)locale, (boolean)withCountry));
        localizedName.append(".xml");
        return localizedName.toString().trim();
    }

    public static IMessageContentModel getEmailTemplate(String name) throws IOException, URISyntaxException {
        InputStream is = ClassUtils.getResourceAsStream((String)name);
        String xmlString = ReadFileUtils.inputStream2String((InputStream)is);
        IMessageContentModel messageModel = new MessageContentModel().toObject(xmlString);
        return messageModel;
    }
}

