/*
 * Decompiled with CFR 0.152.
 */
package message.system.application.models.utlis;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Locale;
import message.system.application.models.InfoMessageModel;
import message.system.application.models.send.api.IMessageContentModel;
import message.system.application.models.utlis.MessageComposer;
import net.sourceforge.jaulp.locale.Locales;
import org.apache.velocity.runtime.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailComposer {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)EmailComposer.class.getName());

    public static final void main(String ... strings) throws IOException, ParseException, URISyntaxException {
        InfoMessageModel model = EmailComposer.createEmailMessageForForgottenPassword("xy@z.com", "z.com", "abc", "Albert Einstein", "a.e@gmail.com", "yyy", "http://www.xy.com/bla=fasel", Locales.GREEK);
        System.out.println(model.getMessageContentModel().getSubject());
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("recipientFullName", "Albert Einstein");
        context.put("urlForForgottenPassword", "http://www.xy.com/bla=fasel");
        context.put("username", "albert");
        context.put("newPassword", "xxx");
        context.put("applicationDomainName", "z.com");
        IMessageContentModel messageModel = MessageComposer.createMessageModel(context, "mail/templates/forgotten/pw/ForgottenPassword", null);
        System.out.println("Subject:\n" + messageModel.getSubject());
        System.out.println("Content:\n" + messageModel.getContent());
        messageModel = MessageComposer.createMessageModel(context, "mail/templates/forgotten/pw/ForgottenPassword", Locales.GREEK);
        System.out.println("Subject:\n" + messageModel.getSubject());
        System.out.println("Content:\n" + messageModel.getContent());
        messageModel = MessageComposer.createMessageModel(context, "mail/templates/forgotten/pw/ForgottenPassword", Locale.GERMAN);
        System.out.println("Subject:\n" + messageModel.getSubject());
        System.out.println("Content:\n" + messageModel.getContent());
        messageModel = MessageComposer.createMessageModel(context, "mail/templates/forgotten/pw/ForgottenPassword", Locale.ENGLISH);
        System.out.println("Subject:\n" + messageModel.getSubject());
        System.out.println("Content:\n" + messageModel.getContent());
    }

    public static InfoMessageModel createEmailMessageForForgottenPassword(String applicationSenderAddress, String applicationDomainName, String username, String recipientFullName, String recipientEmailContact, String newPassword, String urlForForgottenPassword, Locale locale) {
        String xmlMailTemplatePath = "mail/templates/forgotten/pw/";
        String xmlMailTemplateFileName = "ForgottenPassword";
        String xmlMailTemplateName = xmlMailTemplatePath + xmlMailTemplateFileName;
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("recipientFullName", recipientFullName);
        context.put("urlForForgottenPassword", urlForForgottenPassword);
        context.put("username", username);
        context.put("newPassword", newPassword);
        context.put("applicationDomainName", applicationDomainName);
        IMessageContentModel messageModel = null;
        try {
            messageModel = MessageComposer.createMessageModel(context, xmlMailTemplateName, locale);
        }
        catch (IOException e) {
            LOGGER.error("Xml file could not be found.", (Throwable)e);
        }
        catch (ParseException e) {
            LOGGER.error("Template could not be parsed.", (Throwable)e);
        }
        catch (URISyntaxException e) {
            LOGGER.error("Xml file could not be found.", (Throwable)e);
        }
        InfoMessageModel infoMessageModel = new InfoMessageModel();
        infoMessageModel.setApplicationDomainName(applicationDomainName);
        infoMessageModel.setApplicationSenderAddress(applicationSenderAddress);
        infoMessageModel.setMessageContentModel(messageModel);
        infoMessageModel.setRecipientEmailContact(recipientEmailContact);
        infoMessageModel.setRecipientFullName(recipientFullName);
        return infoMessageModel;
    }

    public static InfoMessageModel createEmailForMemberSendResponse(String applicationSenderAddress, String applicationDomainName, String username, String recipientFullName, String recipientEmailContact, String messagePart, Locale locale) {
        String xmlMailTemplatePath = "mail/templates/response/sent/";
        String xmlMailTemplateFileName = "MemberSendResponse";
        String xmlMailTemplateName = xmlMailTemplatePath + xmlMailTemplateFileName;
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("recipientFullName", recipientFullName);
        context.put("memberUsername", username);
        context.put("messagePart", messagePart);
        context.put("applicationDomainName", applicationDomainName);
        IMessageContentModel messageModel = null;
        try {
            messageModel = MessageComposer.createMessageModel(context, xmlMailTemplateName, locale);
        }
        catch (IOException e) {
            LOGGER.error("Xml file could not be found.", (Throwable)e);
        }
        catch (ParseException e) {
            LOGGER.error("Template could not be parsed.", (Throwable)e);
        }
        catch (URISyntaxException e) {
            LOGGER.error("Xml file could not be found.", (Throwable)e);
        }
        InfoMessageModel infoMessageModel = new InfoMessageModel();
        infoMessageModel.setApplicationDomainName(applicationDomainName);
        infoMessageModel.setApplicationSenderAddress(applicationSenderAddress);
        infoMessageModel.setMessageContentModel(messageModel);
        infoMessageModel.setRecipientEmailContact(recipientEmailContact);
        infoMessageModel.setRecipientFullName(recipientFullName);
        return infoMessageModel;
    }

    public static InfoMessageModel createEmailMessageForRecommendProfile(String applicationSenderAddress, String applicationDomainName, String memberUsername, String recipientFullName, String recipientEmailContact, String profileData, String profileLink, String invitationText, String senderProfileLink, String signupLink, Locale locale) {
        String xmlMailTemplatePath = "mail/templates/recommend/profile/";
        String xmlMailTemplateFileName = "MemberSendRecommendation";
        String xmlMailTemplateName = xmlMailTemplatePath + xmlMailTemplateFileName;
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("memberUsername", memberUsername);
        context.put("profileData", profileData);
        context.put("profileLink", profileLink);
        context.put("invitationText", invitationText);
        context.put("senderProfileLink", senderProfileLink);
        context.put("signupLink", signupLink);
        context.put("applicationDomainName", applicationDomainName);
        IMessageContentModel messageModel = null;
        try {
            messageModel = MessageComposer.createMessageModel(context, xmlMailTemplateName, locale);
        }
        catch (IOException e) {
            LOGGER.error("Xml file could not be found.", (Throwable)e);
        }
        catch (ParseException e) {
            LOGGER.error("Template could not be parsed.", (Throwable)e);
        }
        catch (URISyntaxException e) {
            LOGGER.error("Xml file could not be found.", (Throwable)e);
        }
        InfoMessageModel infoMessageModel = new InfoMessageModel();
        infoMessageModel.setApplicationDomainName(applicationDomainName);
        infoMessageModel.setApplicationSenderAddress(applicationSenderAddress);
        infoMessageModel.setMessageContentModel(messageModel);
        infoMessageModel.setRecipientEmailContact(recipientEmailContact);
        infoMessageModel.setRecipientFullName(recipientFullName);
        return infoMessageModel;
    }
}

