create index IDX_FEDERALSTATE_ID on addresses (federalstate_id);
create index IDX_ZIPCODE_ID on addresses (zipcode_id);
alter table addresses add constraint FK_ADDRESSES_FEDERALSTATE_ID foreign key (federalstate_id) references federalstates;
alter table addresses add constraint FK_ADDRESSES_ZIPCODE_ID foreign key (zipcode_id) references zipcodes;
alter table base_attributes add constraint FK82063B85D4CCA38D foreign key (base_attributes_id) references BaseAttributesEntity;
alter table base_attributes add constraint FK82063B8520E98507 foreign key (attributes_id) references attributes;
alter table blacklisted_contacts add constraint FKA1253AB66B955CF9 foreign key (blacklisted_id) references users;
alter table blacklisted_contacts add constraint FKA1253AB6A09C615E foreign key (user_data_id) references user_data;
create index IDX_COUNTRY_ID on federalstates (country_id);
alter table federalstates add constraint FK_FEDERAL_STATES_COUNTRY_ID foreign key (country_id) references countries;
alter table message_attachments add constraint FK64E05778442255DC foreign key (message_id) references messages;
alter table message_attachments add constraint FK64E05778E812C08D foreign key (resource_id) references resources;
create index IDX_RECIPIENT_ID on message_recipients (recipient_id);
create index IDX_MESSAGE_RECIPIENTS_ID on message_recipients (message_id);
create index IDX_RECIPIENT_EMAIL on message_recipients (recipient_email);
alter table message_recipients add constraint FK_MESSAGE_RECIPIENTS_RECIPIENT_EMAIL foreign key (recipient_email) references contactmethods;
alter table message_recipients add constraint FK_MESSAGE_RECIPIENTS_RECIPIENT_ID foreign key (recipient_id) references users;
alter table message_recipients add constraint FK_MESSAGE_RECIPIENTS_MESSAGE_ID foreign key (message_id) references messages;
create index IDX_PARENT_MESSAGE_ID on messages (parent);
create index IDX_SENDER on messages (sender);
create index IDX_SENDER_EMAIL on messages (sender_email);
alter table messages add constraint FK_MESSAGES_SENDER foreign key (sender) references users;
alter table messages add constraint FK_MESSAGES_SENDER_EMAIL foreign key (sender_email) references contactmethods;
alter table messages add constraint FK_PARENT_MESSAGE_ID foreign key (parent) references messages;
create index IDX_RECOMMENDATIONS_USER_ID on recommendations (user_id);
create index IDX_RECOMMENDATIONS_RECOMMENDED_ID on recommendations (recommended_id);
alter table recommendations add constraint FK_RECOMMENDATIONS_USER_ID foreign key (user_id) references users;
alter table recommendations add constraint FK_RECOMMENDATIONS_RECOMMENDED_ID foreign key (recommended_id) references users;
create index IDX_PROVIDER_ID on relation_permissions (provider_id);
create index IDX_SUBSCRIBER_ID on relation_permissions (subscriber_id);
alter table relation_permissions add constraint FK_USER_RELATION_PERMISSIONS_PROVIDER_ID foreign key (provider_id) references users;
alter table relation_permissions add constraint FK_USER_RELATION_PERMISSIONS_SUBSCRIBER_ID foreign key (subscriber_id) references users;
create index IDX_RESET_PASSWORDS_USER_ID on reset_passwords (user_id);
alter table reset_passwords add constraint FK_RESET_PASSWORDS_USER_ID foreign key (user_id) references users;
create index IDX_ROBINSON_USER_ID on robinsons (robinson_user_id);
alter table robinsons add constraint FK_ROBINSON_USER_ID foreign key (robinson_user_id) references users;
alter table role_permissions add constraint FKEAD9D23B5682C574 foreign key (role_id) references roles;
alter table role_permissions add constraint FKEAD9D23B70D24902 foreign key (permission_id) references permissions;
create index IDX_VIOLATOR_USER_ID on rule_violations (violator_user_id);
create index IDX_DETECTOR_USER_ID on rule_violations (detector_user_id);
alter table rule_violations add constraint FK_DETECTOR_USER_ID foreign key (detector_user_id) references users;
alter table rule_violations add constraint FK_VIOLATOR_USER_ID foreign key (violator_user_id) references users;
alter table user_addresses add constraint FK9188602EA09C615E foreign key (user_data_id) references user_data;
alter table user_addresses add constraint FK9188602ED634EE8A foreign key (addresses_id) references addresses;
alter table user_contactmethods add constraint FKA59F56868708F8A7 foreign key (contactmethods_id) references contactmethods;
alter table user_contactmethods add constraint FKA59F5686A09C615E foreign key (user_data_id) references user_data;
alter table user_contacts add constraint FKE130BA47A09C615E foreign key (user_data_id) references user_data;
alter table user_contacts add constraint FKE130BA475C8835C9 foreign key (user_contact_id) references users;
create index IDX_PRIMARY_ADDRESS_ID on user_data (primary_address_id);
alter table user_data add constraint FK_USER_DATA_PRIMARY_ADDRESS_ID foreign key (primary_address_id) references addresses;
alter table user_relation_permissions add constraint FKDBE83EB570D24902 foreign key (permission_id) references permissions;
alter table user_relation_permissions add constraint FKDBE83EB51DB40057 foreign key (user_relation_permission_id) references relation_permissions;
alter table user_resources add constraint FKE734A2B1A09C615E foreign key (user_data_id) references user_data;
alter table user_resources add constraint FKE734A2B187A1FB16 foreign key (resources_id) references resources;
alter table user_roles add constraint FK734299495682C574 foreign key (role_id) references roles;
alter table user_roles add constraint FK73429949FBD81D4A foreign key (user_id) references users;
alter table users add constraint FK6A68E083DCC3A0 foreign key (user_data) references user_data;
create index IDX_ZIP_CODES_COUNTRY_ID on zipcodes (country_id);
alter table zipcodes add constraint FK_ZIP_CODES_COUNTRY_ID foreign key (country_id) references countries;
create sequence hibernate_sequence;
