/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.message.system.entities;

import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.postgres.usertype.PGEnumUserType;
import de.alpharogroup.message.system.enums.MessageState;
import de.alpharogroup.message.system.enums.MessageType;
import de.alpharogroup.resource.system.entities.Resources;
import de.alpharogroup.user.management.entities.Contactmethods;
import de.alpharogroup.user.management.entities.Users;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;

@Entity
@Table(name="messages")
@TypeDefs(value={@TypeDef(name="messagetypeConverter", typeClass=PGEnumUserType.class, parameters={@Parameter(name="enumClassName", value="de.alpharogroup.message.system.enums.MessageType")}), @TypeDef(name="stateConverter", typeClass=PGEnumUserType.class, parameters={@Parameter(name="enumClassName", value="de.alpharogroup.message.system.enums.MessageState")})})
public class Messages
extends BaseEntity<Integer>
implements Cloneable {
    private static final long serialVersionUID = 920286633675636537L;
    @OneToOne
    @JoinColumn(name="parent", foreignKey=@ForeignKey(name="FK_PARENT_MESSAGE_ID"))
    private Messages parent;
    @Column(name="sender_deleted_flag")
    private Boolean senderDeletedFlag;
    @Column(name="recipient_deleted_flag")
    private Boolean recipientDeletedFlag;
    @Column(name="failed2sentemail")
    private Boolean failed2sentemail;
    @Column(name="folder", length=64)
    private String folder;
    @Column(name="messageContent", length=21845)
    private String messageContent;
    @Enumerated(value=EnumType.STRING)
    @Column(name="messagetype")
    @Type(type="messagetypeConverter")
    private MessageType messagetype;
    @Column(name="read_flag")
    private Boolean readFlag;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="sender", nullable=true, referencedColumnName="id", foreignKey=@ForeignKey(name="FK_MESSAGES_SENDER"))
    private Users sender;
    @ManyToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="sender_email", nullable=true, referencedColumnName="id", foreignKey=@ForeignKey(name="FK_MESSAGES_SENDER_EMAIL"))
    private Contactmethods senderEmail;
    @Column(name="sent_date")
    private Date sentDate;
    @Column(name="spam_flag")
    private Boolean spamFlag;
    @Enumerated(value=EnumType.STRING)
    @Column(name="state")
    @Type(type="stateConverter")
    private MessageState state;
    @Column(name="subject", length=1000)
    private String subject;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="message_attachments", joinColumns={@JoinColumn(name="message_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="resource_id", referencedColumnName="id")})
    private Set<Resources> attachments = new HashSet<Resources>();

    public boolean isSpamFlag() {
        return this.getSpamFlag() != null && this.getSpamFlag() != false;
    }

    public Messages getParent() {
        return this.parent;
    }

    public Boolean getSenderDeletedFlag() {
        return this.senderDeletedFlag;
    }

    public Boolean getRecipientDeletedFlag() {
        return this.recipientDeletedFlag;
    }

    public Boolean getFailed2sentemail() {
        return this.failed2sentemail;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getMessageContent() {
        return this.messageContent;
    }

    public MessageType getMessagetype() {
        return this.messagetype;
    }

    public Boolean getReadFlag() {
        return this.readFlag;
    }

    public Users getSender() {
        return this.sender;
    }

    public Contactmethods getSenderEmail() {
        return this.senderEmail;
    }

    public Date getSentDate() {
        return this.sentDate;
    }

    public Boolean getSpamFlag() {
        return this.spamFlag;
    }

    public MessageState getState() {
        return this.state;
    }

    public String getSubject() {
        return this.subject;
    }

    public Set<Resources> getAttachments() {
        return this.attachments;
    }

    public void setParent(Messages parent) {
        this.parent = parent;
    }

    public void setSenderDeletedFlag(Boolean senderDeletedFlag) {
        this.senderDeletedFlag = senderDeletedFlag;
    }

    public void setRecipientDeletedFlag(Boolean recipientDeletedFlag) {
        this.recipientDeletedFlag = recipientDeletedFlag;
    }

    public void setFailed2sentemail(Boolean failed2sentemail) {
        this.failed2sentemail = failed2sentemail;
    }

    public void setFolder(String folder) {
        this.folder = folder;
    }

    public void setMessageContent(String messageContent) {
        this.messageContent = messageContent;
    }

    public void setMessagetype(MessageType messagetype) {
        this.messagetype = messagetype;
    }

    public void setReadFlag(Boolean readFlag) {
        this.readFlag = readFlag;
    }

    public void setSender(Users sender) {
        this.sender = sender;
    }

    public void setSenderEmail(Contactmethods senderEmail) {
        this.senderEmail = senderEmail;
    }

    public void setSentDate(Date sentDate) {
        this.sentDate = sentDate;
    }

    public void setSpamFlag(Boolean spamFlag) {
        this.spamFlag = spamFlag;
    }

    public void setState(MessageState state) {
        this.state = state;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setAttachments(Set<Resources> attachments) {
        this.attachments = attachments;
    }
}

