/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.message.system.service;

import de.alpharogroup.email.messages.EmailMessage;
import de.alpharogroup.email.send.SendEmail;
import de.alpharogroup.email.utils.EmailExtensions;
import de.alpharogroup.message.system.application.models.InfoMessageModel;
import de.alpharogroup.string.StringExtensions;
import java.util.Map;
import javax.mail.MessagingException;
import org.apache.log4j.Logger;

public class SendMessageBusinessService {
    private static final Logger LOGGER = Logger.getLogger((String)SendMessageBusinessService.class.getName());

    public static void sendEmail(SendEmail emailSender, String senderEmail, String senderPersonal, String recipientEmail, String recipientPersonal, String subject, String content) throws MessagingException {
        SendMessageBusinessService.sendEmail(emailSender, senderEmail, senderPersonal, recipientEmail, recipientPersonal, subject, content, null);
    }

    public static void sendEmail(SendEmail emailSender, String senderEmail, String senderPersonal, String recipientEmail, String recipientPersonal, String subject, String content, Map<String, String> emailHeaders) throws MessagingException {
        SendMessageBusinessService.sendEmail(emailSender, senderEmail, senderPersonal, recipientEmail, recipientPersonal, subject, content, emailHeaders, false);
    }

    public static void sendEmail(SendEmail emailSender, String senderEmail, String senderPersonal, String recipientEmail, String recipientPersonal, String subject, String content, Map<String, String> emailHeaders, boolean withSession) throws MessagingException {
        EmailMessage emailMessage = withSession ? new EmailMessage(emailSender.getSession()) : new EmailMessage();
        EmailExtensions.setFromToEmailMessage((String)senderEmail, (String)senderPersonal, (String)"UTF-8", (EmailMessage)emailMessage);
        EmailExtensions.addToRecipientToEmailMessage((String)recipientEmail, (String)recipientPersonal, (String)"UTF-8", (EmailMessage)emailMessage);
        LOGGER.debug((Object)("Subject:" + subject));
        subject = StringExtensions.removeNewlineCharacters((String)subject);
        emailMessage.setSubject(subject);
        LOGGER.debug((Object)("Content:" + content));
        emailMessage.setUtf8Content((Object)content);
        if (emailHeaders != null && !emailHeaders.isEmpty()) {
            for (Map.Entry<String, String> emailHeaderEntry : emailHeaders.entrySet()) {
                emailMessage.setHeader(emailHeaderEntry.getKey(), emailHeaderEntry.getValue());
            }
        }
        emailSender.sendEmailMessage(emailMessage);
    }

    public static void sendInfoEmail(SendEmail emailSender, InfoMessageModel model) throws MessagingException {
        SendMessageBusinessService.sendInfoEmail(emailSender, model, null);
    }

    public static void sendInfoEmail(SendEmail emailSender, InfoMessageModel model, Map<String, String> emailHeaders) throws MessagingException {
        SendMessageBusinessService.sendEmail(emailSender, model.getApplicationSenderAddress(), model.getApplicationDomainName(), model.getRecipientEmailContact(), model.getRecipientFullName(), model.getMessageContentModel().getSubject(), model.getMessageContentModel().getContent(), emailHeaders);
    }
}

