/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.message.system.service;

import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.message.system.application.models.send.api.IBaseMessageModel;
import de.alpharogroup.message.system.application.models.utils.MessageModelConverter;
import de.alpharogroup.message.system.daos.MessagesDao;
import de.alpharogroup.message.system.entities.MessageRecipients;
import de.alpharogroup.message.system.entities.Messages;
import de.alpharogroup.message.system.enums.MessageState;
import de.alpharogroup.message.system.enums.MessageType;
import de.alpharogroup.message.system.factories.MessageSystemFactory;
import de.alpharogroup.message.system.service.api.MessageRecipientsService;
import de.alpharogroup.message.system.service.api.MessagesService;
import de.alpharogroup.user.entities.Users;
import de.alpharogroup.user.management.service.api.UsersService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="messagesService")
public class MessagesBusinessService
extends AbstractBusinessService<Messages, Integer, MessagesDao>
implements MessagesService {
    private static final long serialVersionUID = 1L;
    @Autowired
    private MessageRecipientsService messageRecipientsService;
    @Autowired
    private UsersService usersService;

    @Override
    public List<Messages> findAllChildren(Messages parent) {
        List<Messages> children = this.findMessagesChildren(parent);
        ArrayList<Messages> childElements = new ArrayList<Messages>();
        childElements.addAll(children);
        if (children != null) {
            for (Messages child : children) {
                childElements.addAll(this.findAllChildren(child));
            }
        }
        return childElements;
    }

    @Override
    public List<Messages> findMessages(Users user) {
        String hqlString = "select distinct mr.message from " + MessageRecipients.class.getSimpleName() + " as mr where mr.recipient=:user and mr.message.recipientDeletedFlag=:recipientDeletedFlag ";
        Query query = this.getQuery(hqlString);
        query.setParameter("user", (Object)user);
        query.setParameter("recipientDeletedFlag", (Object)Boolean.FALSE);
        List messages = query.getResultList();
        return messages;
    }

    @Override
    public List<Messages> findMessages(Users user, MessageState state) {
        String hqlString = "select distinct mr.message from " + MessageRecipients.class.getSimpleName() + " as mr where mr.recipient=:user and mr.message.state=:state and mr.message.recipientDeletedFlag=:recipientDeletedFlag ";
        Query query = this.getQuery(hqlString);
        query.setParameter("user", (Object)user);
        query.setParameter("state", (Object)state);
        query.setParameter("recipientDeletedFlag", (Object)Boolean.FALSE);
        List messages = query.getResultList();
        return messages;
    }

    @Override
    public List<Messages> findMessagesChildren(Messages parent) {
        String hqlString = "select distinct m from " + Messages.class.getSimpleName() + " as m where m.parent=:parent";
        Query query = this.getQuery(hqlString);
        query.setParameter("parent", (Object)parent);
        List messages = query.getResultList();
        if (null != messages && !messages.isEmpty()) {
            return messages;
        }
        return null;
    }

    @Override
    public List<Messages> findReplyMessages(Users user) {
        String hqlString = "select distinct m from " + Messages.class.getSimpleName() + " as m where m.sender=:user and m.parent is not null and m.messagetype=:messagetype";
        Query query = this.getQuery(hqlString);
        query.setParameter("user", (Object)user);
        query.setParameter("messagetype", (Object)MessageType.REPLY);
        List messages = query.getResultList();
        return messages;
    }

    @Override
    public List<Messages> findSentMessages(Users user) {
        String hqlString = "select distinct m from " + Messages.class.getSimpleName() + " as m where m.sender=:user and m.senderDeletedFlag=:senderDeletedFlag";
        Query query = this.getQuery(hqlString);
        query.setParameter("user", (Object)user);
        query.setParameter("senderDeletedFlag", (Object)Boolean.FALSE);
        List messages = query.getResultList();
        return messages;
    }

    public MessageRecipientsService getMessageRecipientsService() {
        return this.messageRecipientsService;
    }

    @Override
    public Set<Users> getRecipients(Messages message) {
        String hqlString = "select mr.recipient from " + MessageRecipients.class.getSimpleName() + " mr where mr.message=:message";
        Query query = this.getQuery(hqlString);
        query.setParameter("message", (Object)message);
        List recipients = query.getResultList();
        if (recipients != null && !recipients.isEmpty()) {
            return new HashSet<Users>(recipients);
        }
        return null;
    }

    public UsersService getUsersService() {
        return this.usersService;
    }

    @Override
    public boolean isRecipientFrom(Messages message, Users user) {
        Set<Users> recipients = this.getRecipients(message);
        return recipients != null && recipients.contains(user);
    }

    @Override
    public Messages saveMessageWithRecipients(IBaseMessageModel model) {
        if (model.getSendInformationModel().getSender() == null) {
            throw new IllegalArgumentException("Message should have a Sender. Currently Sender is null. Sender should not be null.");
        }
        if (model.getSendInformationModel().getRecipients() == null || model.getSendInformationModel().getRecipients().isEmpty()) {
            throw new IllegalArgumentException("Message should have recipients. Currently recipients is null or empty. At least one recipient should be set.");
        }
        Messages message = MessageModelConverter.createMessage(model);
        message = (Messages)this.merge((BaseEntity)message);
        Set<Users> recipients = model.getSendInformationModel().getRecipients();
        for (Users recipient : recipients) {
            recipient = (Users)this.usersService.get(recipient.getId());
            MessageRecipients messageRecipient = MessageSystemFactory.getInstance().newMessageRecipients(message, recipient);
            this.messageRecipientsService.merge((BaseEntity)messageRecipient);
        }
        return (Messages)this.merge((BaseEntity)message);
    }

    public void setMessageRecipientsService(MessageRecipientsService messageRecipientsService) {
        this.messageRecipientsService = messageRecipientsService;
    }

    @Autowired
    public void setMessagesDao(MessagesDao messagesDao) {
        this.setDao((EntityManagerDao)messagesDao);
    }

    public void setUsersService(UsersService usersService) {
        this.usersService = usersService;
    }
}

