/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.message.system.application.models.utils;

import de.alpharogroup.file.read.ReadFileExtensions;
import de.alpharogroup.lang.ClassExtensions;
import de.alpharogroup.message.system.application.models.send.MessageContentModel;
import de.alpharogroup.message.system.application.models.send.api.IMessageContentModel;
import de.alpharogroup.resourcebundle.locale.LocaleExtensions;
import de.alpharogroup.velocity.VelocityExtensions;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageComposer {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)MessageComposer.class.getName());

    public static IMessageContentModel createMessageModel(Map<String, Object> contextModel, String xmlMailTemplateName, Locale locale) throws IOException, ParseException, URISyntaxException {
        String localizedName = MessageComposer.getXmlMailTemplateName(xmlMailTemplateName, locale, false);
        IMessageContentModel xmlMailTemplate = MessageComposer.getEmailTemplate(localizedName);
        Template subjectTemplate = VelocityExtensions.getTemplate((String)xmlMailTemplate.getSubject());
        Template contentTemplate = VelocityExtensions.getTemplate((String)xmlMailTemplate.getContent());
        VelocityContext context = new VelocityContext(contextModel);
        StringWriter contentWriter = new StringWriter();
        contentTemplate.merge((Context)context, (Writer)contentWriter);
        StringWriter subjectWriter = new StringWriter();
        subjectTemplate.merge((Context)context, (Writer)subjectWriter);
        MessageContentModel result = new MessageContentModel();
        result.setSubject(subjectWriter.toString());
        result.setContent(contentWriter.toString());
        return result;
    }

    public static IMessageContentModel getEmailTemplate(String name) throws IOException, URISyntaxException {
        InputStream is = ClassExtensions.getResourceAsStream((String)name);
        String xmlString = ReadFileExtensions.inputStream2String((InputStream)is);
        IMessageContentModel messageModel = new MessageContentModel().toObject(xmlString);
        return messageModel;
    }

    public static String getXmlMailTemplateName(String xmlMailTemplateName, Locale locale, boolean withCountry) {
        StringBuilder localizedName = new StringBuilder();
        localizedName.append(xmlMailTemplateName);
        localizedName.append(LocaleExtensions.getLocaleFileSuffix((Locale)locale, (boolean)withCountry));
        localizedName.append(".xml");
        return localizedName.toString().trim();
    }
}

