/**
 * The MIT License
 *
 * Copyright (C) 2015 Asterios Raptis
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *  *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *  *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package de.alpharogroup.message.system.application.models.send;

import java.io.Serializable;

import de.alpharogroup.xml.XmlExtensions;
import de.alpharogroup.xml.api.Transformable;

/**
 * The Class SendMessagePanelModel.
 */
public class SendMessagePanelModel implements Serializable, Transformable<SendMessagePanelModel>
{

	/**
	 * The serialVersionUID.
	 */
	private static final long serialVersionUID = 1L;

	/** The from. */
	private String recipient;

	/** The subject. */
	private String subject;

	/** The message content. */
	private String messageContent;

	/**
	 * Instantiates a new send message model.
	 */
	public SendMessagePanelModel()
	{
	}

	/**
	 * Gets the message content.
	 * 
	 * @return the message content
	 */
	public String getMessageContent()
	{
		return messageContent;
	}

	/**
	 * Gets the recipient.
	 * 
	 * @return the recipient
	 */
	public String getRecipient()
	{
		return recipient;
	}

	/**
	 * Gets the subject.
	 * 
	 * @return the subject
	 */
	public String getSubject()
	{
		return subject;
	}

	/**
	 * Sets the message content.
	 * 
	 * @param messageContent
	 *            the new message content
	 */
	public void setMessageContent(String messageContent)
	{
		this.messageContent = messageContent;
	}

	/**
	 * Sets the recipient.
	 * 
	 * @param recipient
	 *            the new recipient
	 */
	public void setRecipient(String recipient)
	{
		this.recipient = recipient;
	}

	/**
	 * Sets the subject.
	 * 
	 * @param subject
	 *            the new subject
	 */
	public void setSubject(String subject)
	{
		this.subject = subject;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public SendMessagePanelModel toObject(String xml)
	{
		SendMessagePanelModel model = XmlExtensions.toObjectWithXStream(xml);
		return model;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toXml()
	{
		String xmlString = XmlExtensions.toXmlWithXStream(this);
		return xmlString;

	}

}
