/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lottery.wincategories;

import de.alpharogroup.collections.CollectionExtensions;
import de.alpharogroup.collections.set.SetFactory;
import de.alpharogroup.lottery.wincategories.WinCategory;
import de.alpharogroup.lottery.wincategories.WinningOpportunity;
import java.util.Collection;
import java.util.Optional;

public enum LotteryWinCategory implements WinningOpportunity
{
    EIGHTH_CLASS(WinCategory.builder().quotaOfProfit(45.0).quantityOfWonNumbers(3).withSuperNumber(false).build()),
    FIFTH_CLASS(WinCategory.builder().quotaOfProfit(5.0).quantityOfWonNumbers(4).withSuperNumber(true).build()),
    FIRST_CLASS(WinCategory.builder().quotaOfProfit(12.8).quantityOfWonNumbers(6).withSuperNumber(true).build()),
    FOURTH_CLASS(WinCategory.builder().quotaOfProfit(15.0).quantityOfWonNumbers(5).withSuperNumber(false).build()),
    NINTH_CLASS(WinCategory.builder().fixedWinningUnits(5).quantityOfWonNumbers(2).withSuperNumber(true).build()),
    NONE(null),
    SECOND_CLASS(WinCategory.builder().quotaOfProfit(10.0).quantityOfWonNumbers(6).withSuperNumber(false).build()),
    SEVENTH_CLASS(WinCategory.builder().quotaOfProfit(10.0).quantityOfWonNumbers(3).withSuperNumber(true).build()),
    SIXTH_CLASS(WinCategory.builder().quotaOfProfit(10.0).quantityOfWonNumbers(4).withSuperNumber(false).build()),
    THIRD_CLASS(WinCategory.builder().quotaOfProfit(5.0).quantityOfWonNumbers(5).withSuperNumber(true).build());

    private final WinCategory winCategory;

    public static Optional<LotteryWinCategory> getLotteryWinCategory(Collection<Integer> wonLotteryTicket, boolean withSuperNumber) {
        int size = wonLotteryTicket.size();
        Optional<LotteryWinCategory> optional = Optional.of(NONE);
        if (size == 6) {
            if (withSuperNumber) {
                optional = Optional.of(FIRST_CLASS);
            }
            if (!withSuperNumber) {
                optional = Optional.of(SECOND_CLASS);
            }
        }
        if (size == 5) {
            if (withSuperNumber) {
                optional = Optional.of(THIRD_CLASS);
            }
            if (!withSuperNumber) {
                optional = Optional.of(FOURTH_CLASS);
            }
        }
        if (size == 4) {
            if (withSuperNumber) {
                optional = Optional.of(FIFTH_CLASS);
            }
            if (!withSuperNumber) {
                optional = Optional.of(SIXTH_CLASS);
            }
        }
        if (size == 3) {
            if (withSuperNumber) {
                optional = Optional.of(SEVENTH_CLASS);
            }
            if (!withSuperNumber) {
                optional = Optional.of(EIGHTH_CLASS);
            }
        }
        if (size == 2 && withSuperNumber) {
            optional = Optional.of(NINTH_CLASS);
        }
        return optional;
    }

    public static Optional<LotteryWinCategory> getLotteryWinCategory(Collection<Integer> drawnLotteryNumbers, Collection<Integer> playedLotteryTicket, boolean withSuperNumber) {
        Collection wonNumbers = CollectionExtensions.intersection((Collection[])new Collection[]{SetFactory.newTreeSet(drawnLotteryNumbers, (Object[])new Integer[0]), playedLotteryTicket});
        return LotteryWinCategory.getLotteryWinCategory(wonNumbers, withSuperNumber);
    }

    public WinCategory getWinCategory() {
        return this.winCategory;
    }

    private LotteryWinCategory(WinCategory winCategory) {
        this.winCategory = winCategory;
    }
}

