/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lottery.wincategories;

import de.alpharogroup.lottery.wincategories.WinningOpportunity;

public class EuroMillionsWinCategory
implements Cloneable,
WinningOpportunity {
    private final String computation;
    private final double payoutRate;
    private final int quantityOfWonNumbers;
    private final int quantityOfWonStarNumbers;
    private final boolean withJoker;

    protected Object clone() throws CloneNotSupportedException {
        EuroMillionsWinCategory clone = EuroMillionsWinCategory.builder().computation(this.computation).payoutRate(this.payoutRate).withJoker(this.withJoker).quantityOfWonNumbers(this.quantityOfWonNumbers).quantityOfWonStarNumbers(this.quantityOfWonStarNumbers).build();
        return clone;
    }

    public static EuroMillionsWinCategoryBuilder builder() {
        return new EuroMillionsWinCategoryBuilder();
    }

    public EuroMillionsWinCategoryBuilder toBuilder() {
        return new EuroMillionsWinCategoryBuilder().computation(this.computation).payoutRate(this.payoutRate).quantityOfWonNumbers(this.quantityOfWonNumbers).quantityOfWonStarNumbers(this.quantityOfWonStarNumbers).withJoker(this.withJoker);
    }

    public String getComputation() {
        return this.computation;
    }

    public double getPayoutRate() {
        return this.payoutRate;
    }

    public int getQuantityOfWonNumbers() {
        return this.quantityOfWonNumbers;
    }

    public int getQuantityOfWonStarNumbers() {
        return this.quantityOfWonStarNumbers;
    }

    public boolean isWithJoker() {
        return this.withJoker;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EuroMillionsWinCategory)) {
            return false;
        }
        EuroMillionsWinCategory other = (EuroMillionsWinCategory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getPayoutRate(), other.getPayoutRate()) != 0) {
            return false;
        }
        if (this.getQuantityOfWonNumbers() != other.getQuantityOfWonNumbers()) {
            return false;
        }
        if (this.getQuantityOfWonStarNumbers() != other.getQuantityOfWonStarNumbers()) {
            return false;
        }
        if (this.isWithJoker() != other.isWithJoker()) {
            return false;
        }
        String this$computation = this.getComputation();
        String other$computation = other.getComputation();
        return !(this$computation == null ? other$computation != null : !this$computation.equals(other$computation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EuroMillionsWinCategory;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $payoutRate = Double.doubleToLongBits(this.getPayoutRate());
        result = result * 59 + (int)($payoutRate >>> 32 ^ $payoutRate);
        result = result * 59 + this.getQuantityOfWonNumbers();
        result = result * 59 + this.getQuantityOfWonStarNumbers();
        result = result * 59 + (this.isWithJoker() ? 79 : 97);
        String $computation = this.getComputation();
        result = result * 59 + ($computation == null ? 43 : $computation.hashCode());
        return result;
    }

    public String toString() {
        return "EuroMillionsWinCategory(computation=" + this.getComputation() + ", payoutRate=" + this.getPayoutRate() + ", quantityOfWonNumbers=" + this.getQuantityOfWonNumbers() + ", quantityOfWonStarNumbers=" + this.getQuantityOfWonStarNumbers() + ", withJoker=" + this.isWithJoker() + ")";
    }

    public EuroMillionsWinCategory(String computation, double payoutRate, int quantityOfWonNumbers, int quantityOfWonStarNumbers, boolean withJoker) {
        this.computation = computation;
        this.payoutRate = payoutRate;
        this.quantityOfWonNumbers = quantityOfWonNumbers;
        this.quantityOfWonStarNumbers = quantityOfWonStarNumbers;
        this.withJoker = withJoker;
    }

    public static class EuroMillionsWinCategoryBuilder {
        private String computation;
        private double payoutRate;
        private int quantityOfWonNumbers;
        private int quantityOfWonStarNumbers;
        private boolean withJoker;

        EuroMillionsWinCategoryBuilder() {
        }

        public EuroMillionsWinCategoryBuilder computation(String computation) {
            this.computation = computation;
            return this;
        }

        public EuroMillionsWinCategoryBuilder payoutRate(double payoutRate) {
            this.payoutRate = payoutRate;
            return this;
        }

        public EuroMillionsWinCategoryBuilder quantityOfWonNumbers(int quantityOfWonNumbers) {
            this.quantityOfWonNumbers = quantityOfWonNumbers;
            return this;
        }

        public EuroMillionsWinCategoryBuilder quantityOfWonStarNumbers(int quantityOfWonStarNumbers) {
            this.quantityOfWonStarNumbers = quantityOfWonStarNumbers;
            return this;
        }

        public EuroMillionsWinCategoryBuilder withJoker(boolean withJoker) {
            this.withJoker = withJoker;
            return this;
        }

        public EuroMillionsWinCategory build() {
            return new EuroMillionsWinCategory(this.computation, this.payoutRate, this.quantityOfWonNumbers, this.quantityOfWonStarNumbers, this.withJoker);
        }

        public String toString() {
            return "EuroMillionsWinCategory.EuroMillionsWinCategoryBuilder(computation=" + this.computation + ", payoutRate=" + this.payoutRate + ", quantityOfWonNumbers=" + this.quantityOfWonNumbers + ", quantityOfWonStarNumbers=" + this.quantityOfWonStarNumbers + ", withJoker=" + this.withJoker + ")";
        }
    }
}

