/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lottery.box;

import de.alpharogroup.lottery.enums.LotteryGameType;
import de.alpharogroup.lottery.wincategories.LotteryWinCategory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class LotteryBox {
    private LotteryGameType gameType;
    private Integer index;
    private Set<Integer> selectedNumbers;
    private LotteryWinCategory winCategory;

    public static LotteryBoxBuilder builder() {
        return new LotteryBoxBuilder();
    }

    public LotteryBoxBuilder toBuilder() {
        LotteryBoxBuilder builder = new LotteryBoxBuilder().gameType(this.gameType).index(this.index).winCategory(this.winCategory);
        if (this.selectedNumbers != null) {
            builder.selectedNumbers(this.selectedNumbers);
        }
        return builder;
    }

    public LotteryGameType getGameType() {
        return this.gameType;
    }

    public Integer getIndex() {
        return this.index;
    }

    public Set<Integer> getSelectedNumbers() {
        return this.selectedNumbers;
    }

    public LotteryWinCategory getWinCategory() {
        return this.winCategory;
    }

    public void setGameType(LotteryGameType gameType) {
        this.gameType = gameType;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public void setSelectedNumbers(Set<Integer> selectedNumbers) {
        this.selectedNumbers = selectedNumbers;
    }

    public void setWinCategory(LotteryWinCategory winCategory) {
        this.winCategory = winCategory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LotteryBox)) {
            return false;
        }
        LotteryBox other = (LotteryBox)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$index = this.getIndex();
        Integer other$index = other.getIndex();
        if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
            return false;
        }
        LotteryGameType this$gameType = this.getGameType();
        LotteryGameType other$gameType = other.getGameType();
        if (this$gameType == null ? other$gameType != null : !((Object)((Object)this$gameType)).equals((Object)other$gameType)) {
            return false;
        }
        Set<Integer> this$selectedNumbers = this.getSelectedNumbers();
        Set<Integer> other$selectedNumbers = other.getSelectedNumbers();
        if (this$selectedNumbers == null ? other$selectedNumbers != null : !((Object)this$selectedNumbers).equals(other$selectedNumbers)) {
            return false;
        }
        LotteryWinCategory this$winCategory = this.getWinCategory();
        LotteryWinCategory other$winCategory = other.getWinCategory();
        return !(this$winCategory == null ? other$winCategory != null : !this$winCategory.equals(other$winCategory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LotteryBox;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        LotteryGameType $gameType = this.getGameType();
        result = result * 59 + ($gameType == null ? 43 : ((Object)((Object)$gameType)).hashCode());
        Set<Integer> $selectedNumbers = this.getSelectedNumbers();
        result = result * 59 + ($selectedNumbers == null ? 43 : ((Object)$selectedNumbers).hashCode());
        LotteryWinCategory $winCategory = this.getWinCategory();
        result = result * 59 + ($winCategory == null ? 43 : $winCategory.hashCode());
        return result;
    }

    public String toString() {
        return "LotteryBox(gameType=" + (Object)((Object)this.getGameType()) + ", index=" + this.getIndex() + ", selectedNumbers=" + this.getSelectedNumbers() + ", winCategory=" + this.getWinCategory() + ")";
    }

    public LotteryBox() {
    }

    public LotteryBox(LotteryGameType gameType, Integer index, Set<Integer> selectedNumbers, LotteryWinCategory winCategory) {
        this.gameType = gameType;
        this.index = index;
        this.selectedNumbers = selectedNumbers;
        this.winCategory = winCategory;
    }

    public static class LotteryBoxBuilder {
        private LotteryGameType gameType;
        private Integer index;
        private ArrayList<Integer> selectedNumbers;
        private LotteryWinCategory winCategory;

        LotteryBoxBuilder() {
        }

        public LotteryBoxBuilder gameType(LotteryGameType gameType) {
            this.gameType = gameType;
            return this;
        }

        public LotteryBoxBuilder index(Integer index) {
            this.index = index;
            return this;
        }

        public LotteryBoxBuilder selectedNumber(Integer selectedNumber) {
            if (this.selectedNumbers == null) {
                this.selectedNumbers = new ArrayList();
            }
            this.selectedNumbers.add(selectedNumber);
            return this;
        }

        public LotteryBoxBuilder selectedNumbers(Collection<? extends Integer> selectedNumbers) {
            if (selectedNumbers == null) {
                throw new NullPointerException("selectedNumbers cannot be null");
            }
            if (this.selectedNumbers == null) {
                this.selectedNumbers = new ArrayList();
            }
            this.selectedNumbers.addAll(selectedNumbers);
            return this;
        }

        public LotteryBoxBuilder clearSelectedNumbers() {
            if (this.selectedNumbers != null) {
                this.selectedNumbers.clear();
            }
            return this;
        }

        public LotteryBoxBuilder winCategory(LotteryWinCategory winCategory) {
            this.winCategory = winCategory;
            return this;
        }

        public LotteryBox build() {
            Set<Integer> selectedNumbers;
            switch (this.selectedNumbers == null ? 0 : this.selectedNumbers.size()) {
                case 0: {
                    selectedNumbers = Collections.emptySet();
                    break;
                }
                case 1: {
                    selectedNumbers = Collections.singleton(this.selectedNumbers.get(0));
                    break;
                }
                default: {
                    selectedNumbers = new LinkedHashSet(this.selectedNumbers.size() < 0x40000000 ? 1 + this.selectedNumbers.size() + (this.selectedNumbers.size() - 3) / 3 : Integer.MAX_VALUE);
                    selectedNumbers.addAll(this.selectedNumbers);
                    selectedNumbers = Collections.unmodifiableSet(selectedNumbers);
                }
            }
            return new LotteryBox(this.gameType, this.index, selectedNumbers, this.winCategory);
        }

        public String toString() {
            return "LotteryBox.LotteryBoxBuilder(gameType=" + (Object)((Object)this.gameType) + ", index=" + this.index + ", selectedNumbers=" + this.selectedNumbers + ", winCategory=" + this.winCategory + ")";
        }
    }
}

