/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lottery.drawing;

import de.alpharogroup.collections.list.ListFactory;
import de.alpharogroup.collections.map.MapExtensions;
import de.alpharogroup.collections.map.MapFactory;
import de.alpharogroup.collections.set.SetFactory;
import de.alpharogroup.comparators.ComparatorFactory;
import de.alpharogroup.lottery.drawing.DrawLotteryNumbersFactory;
import de.alpharogroup.random.DefaultSecureRandom;
import de.alpharogroup.random.number.RandomBooleanFactory;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class DrawMultiMapLotteryNumbersFactory {
    private DrawMultiMapLotteryNumbersFactory() {
    }

    public static Set<Integer> drawFromMultiMap(int maxNumbers, int minVolume, int maxVolume, int drawCount) {
        return DrawMultiMapLotteryNumbersFactory.drawFromMultiMap(maxNumbers, minVolume, maxVolume, drawCount, DefaultSecureRandom.get());
    }

    public static Set<Integer> drawFromMultiMap(int maxNumbers, int minVolume, int maxVolume, int drawCount, SecureRandom secureRandom) {
        return DrawMultiMapLotteryNumbersFactory.drawFromMultiMap(maxNumbers, minVolume, maxVolume, drawCount, true, false, secureRandom);
    }

    public static Set<Integer> drawFromMultiMap(int maxNumbers, int minVolume, int maxVolume, int drawCount, boolean mostDrawn) {
        return DrawMultiMapLotteryNumbersFactory.drawFromMultiMap(maxNumbers, minVolume, maxVolume, drawCount, mostDrawn, DefaultSecureRandom.get());
    }

    public static Set<Integer> drawFromMultiMap(int maxNumbers, int minVolume, int maxVolume, int drawCount, boolean mostDrawn, SecureRandom secureRandom) {
        return DrawMultiMapLotteryNumbersFactory.drawFromMultiMap(maxNumbers, minVolume, maxVolume, drawCount, mostDrawn, false, secureRandom);
    }

    public static Set<Integer> drawFromMultiMap(int maxNumbers, int minVolume, int maxVolume, int drawCount, boolean mostDrawn, boolean paranoid) {
        return DrawMultiMapLotteryNumbersFactory.drawFromMultiMap(maxNumbers, minVolume, maxVolume, drawCount, mostDrawn, paranoid, DefaultSecureRandom.get());
    }

    public static Set<Integer> drawFromMultiMap(int maxNumbers, int minVolume, int maxVolume, int drawCount, boolean mostDrawn, boolean paranoid, SecureRandom secureRandom) {
        Map numberCounterMap = MapFactory.newNumberCounterMap((int)minVolume, (int)maxVolume);
        Comparator<Integer> mostDrawnComparator = DrawMultiMapLotteryNumbersFactory.drawFromMultiMap(maxNumbers, minVolume, maxVolume, drawCount, mostDrawn, paranoid, numberCounterMap, secureRandom);
        return DrawMultiMapLotteryNumbersFactory.resolveLotteryNumbers(maxNumbers, mostDrawnComparator, numberCounterMap);
    }

    public static Comparator<Integer> drawFromMultiMap(int maxNumbers, int minVolume, int maxVolume, int drawCount, boolean mostDrawn, boolean paranoid, Map<Integer, Integer> numberCounterMap) {
        return DrawMultiMapLotteryNumbersFactory.drawFromMultiMap(maxNumbers, minVolume, maxVolume, drawCount, mostDrawn, paranoid, numberCounterMap, DefaultSecureRandom.get());
    }

    public static Comparator<Integer> drawFromMultiMap(int maxNumbers, int minVolume, int maxVolume, int drawCount, boolean mostDrawn, boolean paranoid, Map<Integer, Integer> numberCounterMap, SecureRandom secureRandom) {
        return DrawMultiMapLotteryNumbersFactory.newMostDrawnComparator(DrawMultiMapLotteryNumbersFactory.mergeDrawings(maxNumbers, minVolume, maxVolume, drawCount, numberCounterMap), paranoid, mostDrawn, secureRandom);
    }

    public static Comparator<Integer> drawFromMultiMap(int maxNumbers, int minVolume, int maxVolume, int drawCount, Map<Integer, Integer> numberCounterMap) {
        return DrawMultiMapLotteryNumbersFactory.drawFromMultiMap(maxNumbers, minVolume, maxVolume, drawCount, numberCounterMap, DefaultSecureRandom.get());
    }

    public static Comparator<Integer> drawFromMultiMap(int maxNumbers, int minVolume, int maxVolume, int drawCount, Map<Integer, Integer> numberCounterMap, SecureRandom secureRandom) {
        return DrawMultiMapLotteryNumbersFactory.newMostDrawnComparator(DrawMultiMapLotteryNumbersFactory.mergeDrawings(maxNumbers, minVolume, maxVolume, drawCount, numberCounterMap), false, true, secureRandom);
    }

    public static Set<Integer> drawParanoidFromMultiMap(int maxNumbers, int minVolume, int maxVolume, int drawCount) {
        return DrawMultiMapLotteryNumbersFactory.drawParanoidFromMultiMap(maxNumbers, minVolume, maxVolume, drawCount, DefaultSecureRandom.get());
    }

    public static Set<Integer> drawParanoidFromMultiMap(int maxNumbers, int minVolume, int maxVolume, int drawCount, SecureRandom secureRandom) {
        return DrawMultiMapLotteryNumbersFactory.drawFromMultiMap(maxNumbers, minVolume, maxVolume, drawCount, RandomBooleanFactory.randomBoolean(), true, secureRandom);
    }

    private static Comparator<Integer> newMostDrawnComparator(Map<Integer, Integer> numberCounterMap, boolean paranoid, boolean mostDrawn) {
        return DrawMultiMapLotteryNumbersFactory.newMostDrawnComparator(numberCounterMap, paranoid, mostDrawn, DefaultSecureRandom.get());
    }

    private static Comparator<Integer> newMostDrawnComparator(Map<Integer, Integer> numberCounterMap, boolean paranoid, boolean mostDrawn, SecureRandom secureRandom) {
        Comparator mostDrawnComparator;
        if (paranoid) {
            List numberCounterValues = ListFactory.newArrayList((Collection)SetFactory.newTreeSet(numberCounterMap.values(), (Object[])new Integer[0]), (Object[])new Integer[0]);
            Collections.shuffle(numberCounterValues, secureRandom);
            mostDrawnComparator = ComparatorFactory.newComparator((List)numberCounterValues);
        } else {
            mostDrawnComparator = mostDrawn ? Comparator.reverseOrder() : Comparator.naturalOrder();
        }
        return mostDrawnComparator;
    }

    public static Map<Integer, Integer> mergeDrawings(int maxNumbers, int minVolume, int maxVolume, int drawCount, Map<Integer, Integer> numberCounterMap) {
        for (int i = 0; i < drawCount; ++i) {
            DrawLotteryNumbersFactory.draw(maxNumbers, minVolume, maxVolume).forEach(key -> numberCounterMap.merge((Integer)key, 1, Integer::sum));
        }
        return numberCounterMap;
    }

    public static Set<Integer> resolveLotteryNumbers(int maxNumbers, Map<Integer, Integer> numberCounterMap) {
        return DrawMultiMapLotteryNumbersFactory.resolveLotteryNumbers(maxNumbers, DrawMultiMapLotteryNumbersFactory.newMostDrawnComparator(numberCounterMap, false, true), numberCounterMap);
    }

    public static Set<Integer> resolveLotteryNumbers(int maxNumbers, Comparator<Integer> mostDrawn, Map<Integer, Integer> numberCounterMap) {
        List sortByValue = MapExtensions.sortByValueAsList(numberCounterMap, mostDrawn);
        List newLotteryNumbers = sortByValue.stream().map(Map.Entry::getKey).limit(maxNumbers).collect(Collectors.toList());
        return SetFactory.newTreeSet(newLotteryNumbers, (Object[])new Integer[0]);
    }
}

