/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lottery.drawing;

import de.alpharogroup.collections.list.ListFactory;
import de.alpharogroup.collections.set.SetFactory;
import de.alpharogroup.random.DefaultSecureRandom;
import de.alpharogroup.random.number.RandomIntFactory;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;

public final class DrawLotteryNumbersFactory {
    private DrawLotteryNumbersFactory() {
    }

    public static Set<Integer> draw(int maxNumbers, int volume, SecureRandom secureRandom) {
        SortedSet numbers = SetFactory.newTreeSet((Object[])new Integer[0]);
        int cnt = 0;
        while (cnt < maxNumbers) {
            int num = RandomIntFactory.randomIntBetween((int)1, (int)volume, (SecureRandom)secureRandom);
            if (numbers.contains(num)) continue;
            numbers.add(num);
            ++cnt;
        }
        return numbers;
    }

    public static Set<Integer> draw(int maxNumbers, int volume) {
        return DrawLotteryNumbersFactory.draw(maxNumbers, volume, DefaultSecureRandom.get());
    }

    public static Set<Integer> draw(int maxNumbers, int minVolume, int maxVolume, SecureRandom secureRandom) {
        SortedSet numbers = SetFactory.newTreeSet((Object[])new Integer[0]);
        int cnt = 0;
        while (cnt < maxNumbers) {
            int num = RandomIntFactory.randomIntBetween((int)minVolume, (int)maxVolume, (boolean)true, (boolean)true, (SecureRandom)secureRandom);
            if (numbers.contains(num)) continue;
            numbers.add(num);
            ++cnt;
        }
        return numbers;
    }

    public static Set<Integer> drawWithShuffle(int maxNumbers, int minVolume, int maxVolume, SecureRandom secureRandom) {
        SortedSet numbers = SetFactory.newTreeSet((Object[])new Integer[0]);
        ArrayList rangeList = new ArrayList(ListFactory.newRangeList((int)minVolume, (int)maxVolume));
        int cnt = 0;
        while (cnt < maxNumbers) {
            Collections.shuffle(rangeList, secureRandom);
            int index = RandomIntFactory.randomIntBetween((int)0, (int)rangeList.size(), (boolean)true, (boolean)false, (SecureRandom)secureRandom);
            Integer drawnNumber = (Integer)rangeList.get(index);
            if (numbers.contains(drawnNumber)) continue;
            numbers.add(drawnNumber);
            ++cnt;
        }
        return numbers;
    }

    public static Set<Integer> drawWithShuffle(int maxNumbers, int minVolume, int maxVolume) {
        return DrawLotteryNumbersFactory.drawWithShuffle(maxNumbers, minVolume, maxVolume, DefaultSecureRandom.get());
    }

    public static Set<Integer> draw(int maxNumbers, int minVolume, int maxVolume) {
        return DrawLotteryNumbersFactory.draw(maxNumbers, minVolume, maxVolume, DefaultSecureRandom.get());
    }
}

