/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lottery.computation;

import de.alpharogroup.lottery.wincategories.LotteryWinCategory;
import de.alpharogroup.lottery.wincategories.WinEvaluation;
import de.alpharogroup.lottery.wincategories.WinningOpportunity;
import java.util.LinkedHashMap;
import java.util.Map;

public final class UnitEstimationExtensions {
    public static Map<LotteryWinCategory, WinEvaluation<LotteryWinCategory>> calculateFromSecondTillEighthClass(double restUnitsOfPot) {
        LinkedHashMap<LotteryWinCategory, WinEvaluation<LotteryWinCategory>> map = new LinkedHashMap<LotteryWinCategory, WinEvaluation<LotteryWinCategory>>();
        map.put(LotteryWinCategory.SECOND_CLASS, UnitEstimationExtensions.getSecondClassPortion(restUnitsOfPot));
        map.put(LotteryWinCategory.THIRD_CLASS, UnitEstimationExtensions.getThirdClassPortion(restUnitsOfPot));
        map.put(LotteryWinCategory.FOURTH_CLASS, UnitEstimationExtensions.getFourthClassPortion(restUnitsOfPot));
        map.put(LotteryWinCategory.FIFTH_CLASS, UnitEstimationExtensions.getFifthClassPortion(restUnitsOfPot));
        map.put(LotteryWinCategory.SIXTH_CLASS, UnitEstimationExtensions.getSixthClassPortion(restUnitsOfPot));
        map.put(LotteryWinCategory.SEVENTH_CLASS, UnitEstimationExtensions.getSeventhClassPortion(restUnitsOfPot));
        map.put(LotteryWinCategory.EIGHTH_CLASS, UnitEstimationExtensions.getEighthClassPortion(restUnitsOfPot));
        return map;
    }

    public static Map<LotteryWinCategory, WinEvaluation<LotteryWinCategory>> calculateLotteryPot(double unitsInPot, double unitsOfWinClassNine) {
        WinEvaluation<LotteryWinCategory> firstClassPortionWinEvaluation = UnitEstimationExtensions.getFirstClassPortion(unitsInPot);
        double firstClassPortion = firstClassPortionWinEvaluation.getEvaluationOfUnitsResult();
        double restUnitsOfPot = unitsInPot - firstClassPortion;
        double potForSecondTillEighthClass = UnitEstimationExtensions.calculatePotForSecondTillEighthClass(restUnitsOfPot, unitsOfWinClassNine);
        Map<LotteryWinCategory, WinEvaluation<LotteryWinCategory>> lotteryWinCategoryWinEvaluationMap = UnitEstimationExtensions.calculateFromSecondTillEighthClass(potForSecondTillEighthClass);
        lotteryWinCategoryWinEvaluationMap.put(LotteryWinCategory.FIRST_CLASS, firstClassPortionWinEvaluation);
        return lotteryWinCategoryWinEvaluationMap;
    }

    public static double calculatePotForSecondTillEighthClass(double restUnitsOfPot, double unitsOfWinClassNine) {
        return restUnitsOfPot - unitsOfWinClassNine;
    }

    public static WinEvaluation<LotteryWinCategory> getEighthClassPortion(double restUnitsOfPot) {
        double portion = UnitEstimationExtensions.percentageOf(restUnitsOfPot, 45.0);
        return WinEvaluation.builder().winCategory((WinningOpportunity)LotteryWinCategory.EIGHTH_CLASS).evaluationOfUnitsResult(portion).build();
    }

    public static WinEvaluation<LotteryWinCategory> getFifthClassPortion(double restUnitsOfPot) {
        double portion = UnitEstimationExtensions.percentageOf(restUnitsOfPot, 5.0);
        return WinEvaluation.builder().winCategory((WinningOpportunity)LotteryWinCategory.FIFTH_CLASS).evaluationOfUnitsResult(portion).build();
    }

    public static WinEvaluation<LotteryWinCategory> getFirstClassPortion(double unitsInPot) {
        double portion = UnitEstimationExtensions.percentageOf(unitsInPot, 12.8);
        return WinEvaluation.builder().winCategory((WinningOpportunity)LotteryWinCategory.FIRST_CLASS).evaluationOfUnitsResult(portion).build();
    }

    public static WinEvaluation<LotteryWinCategory> getFourthClassPortion(double restUnitsOfPot) {
        double portion = UnitEstimationExtensions.percentageOf(restUnitsOfPot, 15.0);
        return WinEvaluation.builder().winCategory((WinningOpportunity)LotteryWinCategory.FOURTH_CLASS).evaluationOfUnitsResult(portion).build();
    }

    public static WinEvaluation<LotteryWinCategory> getSecondClassPortion(double restUnitsOfPot) {
        double portion = UnitEstimationExtensions.percentageOf(restUnitsOfPot, 10.0);
        return WinEvaluation.builder().winCategory((WinningOpportunity)LotteryWinCategory.SECOND_CLASS).evaluationOfUnitsResult(portion).build();
    }

    public static WinEvaluation<LotteryWinCategory> getSeventhClassPortion(double restUnitsOfPot) {
        double portion = UnitEstimationExtensions.percentageOf(restUnitsOfPot, 10.0);
        return WinEvaluation.builder().winCategory((WinningOpportunity)LotteryWinCategory.SEVENTH_CLASS).evaluationOfUnitsResult(portion).build();
    }

    public static WinEvaluation<LotteryWinCategory> getSixthClassPortion(double restUnitsOfPot) {
        double portion = UnitEstimationExtensions.percentageOf(restUnitsOfPot, 10.0);
        return WinEvaluation.builder().winCategory((WinningOpportunity)LotteryWinCategory.SIXTH_CLASS).evaluationOfUnitsResult(portion).build();
    }

    public static WinEvaluation<LotteryWinCategory> getThirdClassPortion(double restUnitsOfPot) {
        double portion = UnitEstimationExtensions.percentageOf(restUnitsOfPot, 5.0);
        return WinEvaluation.builder().winCategory((WinningOpportunity)LotteryWinCategory.THIRD_CLASS).evaluationOfUnitsResult(portion).build();
    }

    public static double percentageOf(double value, double percentage) {
        return percentage * value / 100.0;
    }

    private UnitEstimationExtensions() {
    }
}

