/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lottery.combinations;

import de.alpharogroup.check.Argument;
import de.alpharogroup.collections.list.ListFactory;
import de.alpharogroup.collections.set.SetExtensions;
import de.alpharogroup.collections.set.SetFactory;
import de.alpharogroup.lottery.box.DoubleSetBox;
import java.util.List;
import java.util.Set;
import org.apache.commons.math3.util.CombinatoricsUtils;

public final class CombinationResolver {
    private static void computeAllCombinations(List<List<Integer>> allCombinations, List<Integer> possibleNumbers, Integer[] currentCombination, int currentStart, int currentEnd, int currentCombinationIndex, int combinationSize) {
        if (currentCombinationIndex == combinationSize) {
            allCombinations.add(ListFactory.newArrayList((Object[])currentCombination));
            return;
        }
        for (int i = currentStart; i <= currentEnd && currentEnd - i + 1 >= combinationSize - currentCombinationIndex; ++i) {
            currentCombination[currentCombinationIndex] = possibleNumbers.get(i);
            CombinationResolver.computeAllCombinations(allCombinations, possibleNumbers, currentCombination, i + 1, currentEnd, currentCombinationIndex + 1, combinationSize);
        }
    }

    public static List<List<Integer>> getAllCombinations(List<Integer> possibleNumbers, int combinationSize) {
        Argument.notNull(possibleNumbers, (String)"possibleNumbers");
        Integer[] currentCombination = new Integer[combinationSize];
        List allCombinations = ListFactory.newArrayList((Object[])new List[0]);
        int currentEnd = possibleNumbers.size() - 1;
        int currentStart = 0;
        int currentCombinationIndex = 0;
        CombinationResolver.computeAllCombinations(allCombinations, possibleNumbers, currentCombination, currentStart, currentEnd, currentCombinationIndex, combinationSize);
        return allCombinations;
    }

    public static long getAllPossibleCombinationsCount(int possibleNumbers, int combinationSize) {
        return CombinatoricsUtils.binomialCoefficient((int)possibleNumbers, (int)combinationSize);
    }

    public static long getAllPossibleCombinationsCount(int firstPossibleNumbers, int firstCombinationSize, int secondPossibleNumbers, int secondCombinationSize) {
        return CombinatoricsUtils.binomialCoefficient((int)firstPossibleNumbers, (int)firstCombinationSize) * CombinatoricsUtils.binomialCoefficient((int)secondPossibleNumbers, (int)secondCombinationSize);
    }

    public static <T> List<List<T>> getCombinations(List<T> possibleValues, int combinationSize) {
        List combinations = ListFactory.newArrayList((Object[])new List[0]);
        if (combinationSize == 0) {
            combinations.add(ListFactory.newArrayList((Object[])new Object[0]));
            return combinations;
        }
        for (int i = 0; i < possibleValues.size(); ++i) {
            T element = possibleValues.get(i);
            List<T> rest = CombinationResolver.getPartialList(possibleValues, i + 1);
            for (List<T> previous : CombinationResolver.getCombinations(rest, combinationSize - 1)) {
                previous.add(element);
                combinations.add(previous);
            }
        }
        return combinations;
    }

    public static <T> Set<DoubleSetBox<T>> getPossibleCombinations(List<T> firstCollection, int firstCollectionCombinationSize, List<T> secondCollection, int secondCollectionCombinationSize) {
        Set doubleSetBoxes = SetFactory.newHashSet((Object[])new DoubleSetBox[0]);
        List<List<T>> firstCollectioncombinations = CombinationResolver.getCombinations(firstCollection, firstCollectionCombinationSize);
        List<List<T>> secondCollectioncombinations = CombinationResolver.getCombinations(secondCollection, secondCollectionCombinationSize);
        for (List<T> fcc : firstCollectioncombinations) {
            for (List<T> scc : secondCollectioncombinations) {
                doubleSetBoxes.add(DoubleSetBox.builder().firstCollection(SetExtensions.toSet(fcc)).secondCollection(SetExtensions.toSet(scc)).build());
            }
        }
        return doubleSetBoxes;
    }

    private static <T> List<T> getPartialList(List<T> list, int i) {
        List partialList = ListFactory.newArrayList((Object[])new Object[0]);
        for (int j = i; j < list.size(); ++j) {
            partialList.add(list.get(j));
        }
        return partialList;
    }
}

