/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lottery.drawing;

import de.alpharogroup.collections.list.ListFactory;
import de.alpharogroup.collections.map.MapExtensions;
import de.alpharogroup.collections.set.SetFactory;
import de.alpharogroup.comparators.ComparatorFactory;
import de.alpharogroup.lottery.drawing.DrawnLotteryNumbersFactory;
import de.alpharogroup.random.DefaultSecureRandom;
import de.alpharogroup.random.number.RandomPrimitivesExtensions;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;

public final class DrawnLotteryNumbersExtensions {
    public static int drawSuperNumber(Set<Integer> alreadyDrawnNumbers, int volume) {
        int superNumber = -1;
        boolean breakout = false;
        while (!breakout) {
            superNumber = RandomPrimitivesExtensions.getRandomIntBetween((int)1, (int)volume);
            if (alreadyDrawnNumbers.contains(superNumber)) continue;
            breakout = true;
        }
        return superNumber;
    }

    public static int drawSuperNumber(Set<Integer> alreadyDrawnNumbers, int minVolume, int maxVolume) {
        int superNumber = -1;
        boolean breakout = false;
        while (!breakout) {
            superNumber = RandomPrimitivesExtensions.randomIntBetween((int)minVolume, (int)maxVolume, (boolean)true, (boolean)true);
            if (alreadyDrawnNumbers.contains(superNumber)) continue;
            breakout = true;
        }
        return superNumber;
    }

    public static int drawGameSeventySeven() {
        return RandomPrimitivesExtensions.randomIntBetween((int)0, (int)9999999, (boolean)true, (boolean)true);
    }

    public static Set<Integer> draw(int maxNumbers, int volume) {
        SortedSet numbers = SetFactory.newTreeSet((Object[])new Integer[0]);
        int cnt = 0;
        while (cnt < maxNumbers) {
            int num = RandomPrimitivesExtensions.getRandomIntBetween((int)1, (int)volume);
            if (numbers.contains(num)) continue;
            numbers.add(num);
            ++cnt;
        }
        return numbers;
    }

    public static Set<Integer> draw(int maxNumbers, int minVolume, int maxVolume) {
        SortedSet numbers = SetFactory.newTreeSet((Object[])new Integer[0]);
        int cnt = 0;
        while (cnt < maxNumbers) {
            int num = RandomPrimitivesExtensions.randomIntBetween((int)minVolume, (int)maxVolume, (boolean)true, (boolean)true);
            if (numbers.contains(num)) continue;
            numbers.add(num);
            ++cnt;
        }
        return numbers;
    }

    public static Set<Integer> drawFromMultiMap(int maxNumbers, int minVolume, int maxVolume, int drawCount) {
        return DrawnLotteryNumbersExtensions.drawFromMultiMap(maxNumbers, minVolume, maxVolume, drawCount, true);
    }

    public static Set<Integer> drawParanoidFromMultiMap(int maxNumbers, int minVolume, int maxVolume, int drawCount) {
        return DrawnLotteryNumbersExtensions.drawFromMultiMap(maxNumbers, minVolume, maxVolume, drawCount, RandomPrimitivesExtensions.randomBoolean(), true);
    }

    public static Set<Integer> drawFromMultiMap(int maxNumbers, int minVolume, int maxVolume, int drawCount, boolean mostDrawn) {
        return DrawnLotteryNumbersExtensions.drawFromMultiMap(maxNumbers, minVolume, maxVolume, drawCount, mostDrawn, false);
    }

    public static Set<Integer> drawFromMultiMap(int maxNumbers, int minVolume, int maxVolume, int drawCount, boolean mostDrawn, boolean paranoid) {
        Comparator mostDrawnComparator;
        Map<Integer, Integer> numberCounterMap = DrawnLotteryNumbersFactory.newNumberCounterMap(minVolume, maxVolume);
        for (int i = 0; i < drawCount; ++i) {
            DrawnLotteryNumbersExtensions.draw(maxNumbers, minVolume, maxVolume).forEach(key -> numberCounterMap.merge((Integer)key, 1, Integer::sum));
        }
        if (paranoid) {
            List numberCounterValues = ListFactory.newArrayList((Collection)SetFactory.newTreeSet(numberCounterMap.values(), (Object[])new Integer[0]), (Object[])new Integer[0]);
            Collections.shuffle(numberCounterValues, DefaultSecureRandom.get());
            mostDrawnComparator = ComparatorFactory.newComparator((List)numberCounterValues);
        } else {
            mostDrawnComparator = mostDrawn ? Comparator.reverseOrder() : Comparator.naturalOrder();
        }
        return DrawnLotteryNumbersExtensions.resolveLotteryNumbers(maxNumbers, mostDrawnComparator, numberCounterMap);
    }

    public static Set<Integer> resolveLotteryNumbers(int maxNumbers, Comparator<Integer> mostDrawn, Map<Integer, Integer> numberCounterMap) {
        List sortByValue = MapExtensions.sortByValueAsList(numberCounterMap, mostDrawn);
        List newLotteryNumbers = sortByValue.stream().map(Map.Entry::getKey).limit(maxNumbers).collect(Collectors.toList());
        return SetFactory.newTreeSet(newLotteryNumbers, (Object[])new Integer[0]);
    }

    public static Set<Integer> drawDefaultAlgorithm(int maxNumbers, int minVolume, int maxVolume) {
        SortedSet numbers = SetFactory.newTreeSet((Object[])new Integer[0]);
        ArrayList rangeList = new ArrayList(ListFactory.newRangeList((int)minVolume, (int)maxVolume));
        SecureRandom sr = DefaultSecureRandom.get();
        int cnt = 0;
        while (cnt < maxNumbers) {
            Collections.shuffle(rangeList, sr);
            int index = RandomPrimitivesExtensions.randomIntBetween((int)0, (int)rangeList.size(), (boolean)true, (boolean)false);
            Integer drawnNumber = (Integer)rangeList.get(index);
            if (numbers.contains(drawnNumber)) continue;
            numbers.add(drawnNumber);
            ++cnt;
        }
        return numbers;
    }

    private DrawnLotteryNumbersExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

