/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lottery.drawing;

import de.alpharogroup.collections.set.SetFactory;
import de.alpharogroup.lottery.drawing.DrawnLotteryNumbersExtensions;
import de.alpharogroup.lottery.drawings.DrawnLotteryNumbers;
import de.alpharogroup.random.RandomExtensions;
import de.alpharogroup.random.SecureRandomBean;
import java.security.SecureRandom;
import java.util.Set;

public final class DrawnLotteryNumbersFactory {
    public static DrawnLotteryNumbers newRandomDrawnLotteryNumbers(int max, int volume) {
        DrawnLotteryNumbers drawnLotteryNumbers = DrawnLotteryNumbers.builder().id(Integer.valueOf(RandomExtensions.randomInt((int)Integer.MAX_VALUE))).lotteryNumbers((Set)SetFactory.newTreeSet((Object[])new Integer[0])).build();
        SecureRandom sr = SecureRandomBean.builder().algorithm("SHA1PRNG").build();
        int cnt = 0;
        while (cnt < max) {
            int num = 1 + Math.abs(sr.nextInt()) % volume;
            if (drawnLotteryNumbers.getLotteryNumbers().contains(num)) continue;
            if (cnt == max - 1) {
                drawnLotteryNumbers.setSuperNumber(Integer.valueOf(num));
            } else {
                drawnLotteryNumbers.getLotteryNumbers().add(num);
            }
            ++cnt;
        }
        drawnLotteryNumbers.setSuperSixNumber(Integer.valueOf(RandomExtensions.randomIntBetween((int)1, (int)10)));
        return drawnLotteryNumbers;
    }

    public static DrawnLotteryNumbers newRandomDrawnLotteryNumbers(int max, int minVolume, int maxVolume) {
        Set<Integer> drawnNumbers = DrawnLotteryNumbersExtensions.draw(max, minVolume, maxVolume);
        return DrawnLotteryNumbers.builder().id(Integer.valueOf(RandomExtensions.randomInt((int)Integer.MAX_VALUE))).lotteryNumbers(drawnNumbers).superNumber(Integer.valueOf(DrawnLotteryNumbersExtensions.drawSuperNumber(drawnNumbers, minVolume, maxVolume))).superSixNumber(Integer.valueOf(RandomExtensions.randomIntBetween((int)1, (int)10))).build();
    }

    public static DrawnLotteryNumbers newRandomDrawnLotteryNumbersDefaultAlgorithm(int max, int volume) {
        Set<Integer> lotteryNumbers = DrawnLotteryNumbersExtensions.draw(max, volume);
        int id = RandomExtensions.randomInt((int)Integer.MAX_VALUE);
        int superNumber = DrawnLotteryNumbersExtensions.drawSuperNumber(lotteryNumbers, volume);
        int superSixNumber = RandomExtensions.randomIntBetween((int)1, (int)10);
        DrawnLotteryNumbers drawnLotteryNumbers = DrawnLotteryNumbers.builder().id(Integer.valueOf(id)).lotteryNumbers(lotteryNumbers).superNumber(Integer.valueOf(superNumber)).superSixNumber(Integer.valueOf(superSixNumber)).build();
        return drawnLotteryNumbers;
    }

    public static DrawnLotteryNumbers newRandomDrawnLotteryNumbers() {
        return DrawnLotteryNumbersFactory.newRandomDrawnLotteryNumbers(7, 49);
    }

    private DrawnLotteryNumbersFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

