/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lottery;

import de.alpharogroup.collections.CollectionExtensions;
import de.alpharogroup.collections.list.ListFactory;
import de.alpharogroup.collections.set.SetFactory;
import de.alpharogroup.lottery.box.LotteryBox;
import de.alpharogroup.lottery.drawing.DrawnLotteryNumbersFactory;
import de.alpharogroup.lottery.drawings.DrawnLotteryNumbers;
import de.alpharogroup.lottery.enums.LotteryGameType;
import de.alpharogroup.lottery.evaluation.EvaluatedLotteryNumbers;
import de.alpharogroup.lottery.played.LotteryPlayedNumbers;
import de.alpharogroup.lottery.ticket.LotteryTicket;
import de.alpharogroup.lottery.wincategories.LotteryWinCategory;
import de.alpharogroup.math.MathExtensions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import lombok.NonNull;

public final class LotteryExtensions {
    private static final Logger log = Logger.getLogger(LotteryExtensions.class.getName());

    public static EvaluatedLotteryNumbers checkResult(DrawnLotteryNumbers drawnLotteryNumbers, LotteryPlayedNumbers lotteryPlayedNumbers) {
        Set drawnLuckyLotteryNumbers = drawnLotteryNumbers.getLotteryNumbers();
        Map playedLotteryNumbers = lotteryPlayedNumbers.getPlayedLotteryNumbers();
        Set playedLotteryTickets = playedLotteryNumbers.keySet();
        EvaluatedLotteryNumbers evaluatedLotteryNumbersBean = EvaluatedLotteryNumbers.builder().build();
        Map wonLotteryNumbersMap = evaluatedLotteryNumbersBean.getWonLotteryNumbers();
        for (LotteryGameType lotteryGameType : playedLotteryTickets) {
            List lotteryTicket = (List)playedLotteryNumbers.get(lotteryGameType);
            List currentWonLotteryNumbersList = ListFactory.newArrayList((Collection)((Collection)wonLotteryNumbersMap.get(lotteryGameType)), (Object[])new Collection[0]);
            wonLotteryNumbersMap.put(lotteryGameType, currentWonLotteryNumbersList);
            for (int i = 0; i < lotteryTicket.size(); ++i) {
                Set currentLotteryPlayedBox = (Set)lotteryTicket.get(i);
                Collection wonNumbers = CollectionExtensions.intersection((Collection[])new Collection[]{SetFactory.newTreeSet((Collection)drawnLuckyLotteryNumbers, (Object[])new Integer[0]), currentLotteryPlayedBox});
                currentWonLotteryNumbersList.add(wonNumbers);
            }
        }
        return evaluatedLotteryNumbersBean;
    }

    public static void evaluate(DrawnLotteryNumbers drawnLotteryNumbers, LotteryTicket playedLotteryTicket) {
        Set lotteryBoxes = playedLotteryTicket.getLotteryBoxes();
        for (LotteryBox lotteryBox : lotteryBoxes) {
            boolean withSuperNumber = lotteryBox.getSelectedNumbers().contains(drawnLotteryNumbers.getSuperNumber());
            Optional lotteryWinCategory = LotteryWinCategory.getLotteryWinCategory((Collection)drawnLotteryNumbers.getLotteryNumbers(), (Collection)lotteryBox.getSelectedNumbers(), (boolean)withSuperNumber);
            lotteryWinCategory.ifPresent(lwc -> lotteryBox.setWinCategory(lwc));
        }
    }

    public static void setWinCategories(EvaluatedLotteryNumbers evaluatedLotteryNumbers) {
        Map wonLotteryNumbersMap = evaluatedLotteryNumbers.getWonLotteryNumbers();
        Set lotteryGameTypeSet = wonLotteryNumbersMap.keySet();
        boolean withSuperNumber = false;
        for (LotteryGameType lotteryGameType : lotteryGameTypeSet) {
            List currentWonLotteryNumbersList = (List)wonLotteryNumbersMap.get(lotteryGameType);
            for (Collection wonLotteryTicket : currentWonLotteryNumbersList) {
                Optional lotteryWinCategory = LotteryWinCategory.getLotteryWinCategory((Collection)wonLotteryTicket, (boolean)withSuperNumber);
                lotteryWinCategory.ifPresent(l -> System.out.println(l.name()));
            }
        }
    }

    public static int calculateDraws(LotteryTicket lotteryTicket, @NonNull LotteryWinCategory lotteryWinCategory) {
        if (lotteryWinCategory == null) {
            throw new NullPointerException("lotteryWinCategory is marked non-null but is null");
        }
        return LotteryExtensions.calculateDraws(lotteryTicket, lotteryWinCategory, 10000);
    }

    public static int calculateDraws(LotteryTicket lotteryTicket, @NonNull LotteryWinCategory lotteryWinCategory, int maxIterations) {
        if (lotteryWinCategory == null) {
            throw new NullPointerException("lotteryWinCategory is marked non-null but is null");
        }
        long startTime = System.nanoTime();
        int count = 0;
        DrawnLotteryNumbers luckyNumbers = DrawnLotteryNumbersFactory.newRandomDrawnLotteryNumbers();
        ++count;
        boolean breakout = false;
        while (!breakout) {
            LotteryExtensions.evaluate(luckyNumbers, lotteryTicket);
            Set lotteryBoxes = lotteryTicket.getLotteryBoxes();
            for (LotteryBox box : lotteryBoxes) {
                if (!box.getWinCategory().equals((Object)LotteryWinCategory.NONE)) {
                    log.info("current draw " + count + " and win category: " + box.getWinCategory().name());
                }
                breakout = box.getWinCategory().equals((Object)lotteryWinCategory);
            }
            luckyNumbers = DrawnLotteryNumbersFactory.newRandomDrawnLotteryNumbers();
            if (maxIterations >= ++count) continue;
            breakout = true;
        }
        log.info("Elapsed time till you have won something: " + LotteryExtensions.calculateElapsedTimeInSeconds(startTime));
        log.info("you have won after " + count + " drawings");
        log.info("you have won: " + lotteryTicket);
        return count;
    }

    public static int calculateDraws(LotteryPlayedNumbers lotteryPlayedNumbers, int winningNumbersCount) {
        return LotteryExtensions.calculateDraws(lotteryPlayedNumbers, winningNumbersCount, 10000);
    }

    public static int calculateDraws(LotteryPlayedNumbers lotteryPlayedNumbers, int winningNumbersCount, int maxIterations) {
        if (!MathExtensions.isBetween((int)1, (int)6, (int)winningNumbersCount)) {
            log.info("winningNumbersCount have to be between 1 and 5");
            return -1;
        }
        long startTime = System.nanoTime();
        int count = 0;
        DrawnLotteryNumbers luckyNumbers = DrawnLotteryNumbersFactory.newRandomDrawnLotteryNumbers();
        ++count;
        EvaluatedLotteryNumbers evaluatedLotteryNumbers = null;
        boolean breakout = false;
        while (!breakout) {
            evaluatedLotteryNumbers = LotteryExtensions.checkResult(luckyNumbers, lotteryPlayedNumbers);
            Map wonLotteryNumbers = evaluatedLotteryNumbers.getWonLotteryNumbers();
            if (!wonLotteryNumbers.isEmpty()) {
                List collections = (List)wonLotteryNumbers.get(LotteryGameType.SIX_OF_FOURTYNINE_NORMAL);
                for (int i = 0; i < collections.size(); ++i) {
                    Collection s = (Collection)collections.get(i);
                    if (winningNumbersCount >= s.size()) continue;
                    breakout = true;
                    break;
                }
            }
            luckyNumbers = DrawnLotteryNumbersFactory.newRandomDrawnLotteryNumbers();
            if (maxIterations >= ++count) continue;
            breakout = true;
        }
        return count;
    }

    public static double calculateElapsedTimeInSeconds(long startTime) {
        return (double)(System.nanoTime() - startTime) / 1000000.0;
    }

    private LotteryExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

