/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lottery.drawing;

import de.alpharogroup.collections.list.ListFactory;
import de.alpharogroup.collections.set.SetFactory;
import de.alpharogroup.random.RandomExtensions;
import de.alpharogroup.random.SecureRandomBean;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DrawnLotteryNumbersExtensions {
    private static final Logger log = Logger.getLogger(DrawnLotteryNumbersExtensions.class.getName());

    public static int drawSuperNumber(Set<Integer> alreadyDrawnNumbers, int volume) {
        SecureRandom sr = SecureRandomBean.builder().algorithm("SHA1PRNG").build();
        int superNumber = -1;
        boolean breakout = false;
        while (!breakout) {
            superNumber = 1 + Math.abs(sr.nextInt()) % volume;
            if (alreadyDrawnNumbers.contains(superNumber)) continue;
            breakout = true;
        }
        return superNumber;
    }

    public static int drawSuperNumber(Set<Integer> alreadyDrawnNumbers, int minVolume, int maxVolume) {
        int superNumber = -1;
        boolean breakout = false;
        while (!breakout) {
            superNumber = RandomExtensions.randomIntBetween((int)minVolume, (int)maxVolume, (boolean)true, (boolean)true);
            if (alreadyDrawnNumbers.contains(superNumber)) continue;
            breakout = true;
        }
        return superNumber;
    }

    public static int drawGameSeventySeven() {
        return RandomExtensions.randomIntBetween((int)0, (int)9999999, (boolean)true, (boolean)true);
    }

    public static Set<Integer> draw(int maxNumbers, int volume) {
        SortedSet numbers = SetFactory.newTreeSet((Object[])new Integer[0]);
        SecureRandom sr = SecureRandomBean.builder().algorithm("SHA1PRNG").build();
        int cnt = 0;
        while (cnt < maxNumbers) {
            int num = 1 + Math.abs(sr.nextInt()) % volume;
            if (numbers.contains(num)) continue;
            numbers.add(num);
            ++cnt;
        }
        return numbers;
    }

    public static Set<Integer> draw(int maxNumbers, int minVolume, int maxVolume) {
        SortedSet numbers = SetFactory.newTreeSet((Object[])new Integer[0]);
        int cnt = 0;
        while (cnt < maxNumbers) {
            int num = RandomExtensions.randomIntBetween((int)minVolume, (int)maxVolume, (boolean)true, (boolean)true);
            if (numbers.contains(num)) continue;
            numbers.add(num);
            ++cnt;
        }
        return numbers;
    }

    public static Set<Integer> drawDefaultAlgorithm(int maxNumbers, int minVolume, int maxVolume) {
        SortedSet numbers = SetFactory.newTreeSet((Object[])new Integer[0]);
        ArrayList rangeList = new ArrayList(ListFactory.newRangeList((int)minVolume, (int)maxVolume));
        SecureRandom sr = SecureRandomBean.builder().algorithm("SHA1PRNG").build();
        int cnt = 0;
        while (cnt < maxNumbers) {
            Collections.shuffle(rangeList, sr);
            int index = RandomExtensions.randomIntBetween((int)0, (int)rangeList.size(), (boolean)true, (boolean)false);
            Integer drawnNumber = (Integer)rangeList.get(index);
            if (rangeList.remove(drawnNumber)) {
                log.log(Level.FINE, "removed drawn number:" + drawnNumber);
            }
            if (numbers.contains(drawnNumber)) continue;
            numbers.add(drawnNumber);
            ++cnt;
        }
        return numbers;
    }

    private DrawnLotteryNumbersExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

