/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lottery.drawing;

import de.alpharogroup.check.Argument;
import de.alpharogroup.collections.list.ListFactory;
import de.alpharogroup.collections.map.MapExtensions;
import de.alpharogroup.collections.map.MapFactory;
import de.alpharogroup.collections.set.SetFactory;
import de.alpharogroup.lottery.drawing.DrawnLotteryNumbersExtensions;
import de.alpharogroup.lottery.drawings.DrawnLotteryNumbers;
import de.alpharogroup.lottery.enums.LotteryAlgorithm;
import de.alpharogroup.random.SecureRandomFactory;
import de.alpharogroup.random.number.RandomPrimitivesExtensions;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class DrawnLotteryNumbersFactory {
    public static Map<Integer, Integer> newNumberCounterMap(int minVolume, int maxVolume) {
        List integerList = ListFactory.newRangeList((int)minVolume, (int)maxVolume);
        Map numberCounterMap = MapFactory.newCounterMap((Collection)integerList);
        return numberCounterMap;
    }

    public static Map<Integer, Integer> newNumberCounterMap(int minVolume, int maxVolume, Map<Integer, Integer> numberCounterMap) {
        Argument.notNull(numberCounterMap, (String)"numberCounterMap");
        return MapExtensions.mergeAndSummarize((Map)MapFactory.newCounterMap((Collection)ListFactory.newRangeList((int)minVolume, (int)maxVolume)), numberCounterMap);
    }

    public static DrawnLotteryNumbers newRandomDrawnLotteryNumbers() {
        return DrawnLotteryNumbersFactory.newRandomDrawnLotteryNumbers(7, 49);
    }

    public static DrawnLotteryNumbers newRandomDrawnLotteryNumbers(int max, int volume) {
        DrawnLotteryNumbers drawnLotteryNumbers = DrawnLotteryNumbers.builder().id(Integer.valueOf(RandomPrimitivesExtensions.randomInt((int)Integer.MAX_VALUE))).lotteryNumbers((Set)SetFactory.newTreeSet((Object[])new Integer[0])).build();
        SecureRandom sr = SecureRandomFactory.newSecureRandom();
        int cnt = 0;
        while (cnt < max) {
            int num = 1 + Math.abs(sr.nextInt()) % volume;
            if (drawnLotteryNumbers.getLotteryNumbers().contains(num)) continue;
            if (cnt == max - 1) {
                drawnLotteryNumbers.setSuperNumber(Integer.valueOf(num));
            } else {
                drawnLotteryNumbers.getLotteryNumbers().add(num);
            }
            ++cnt;
        }
        drawnLotteryNumbers.setSuperSixNumber(Integer.valueOf(RandomPrimitivesExtensions.randomIntBetween((int)1, (int)10)));
        return drawnLotteryNumbers;
    }

    public static DrawnLotteryNumbers newRandomDrawnLotteryNumbers(int max, int minVolume, int maxVolume) {
        Set<Integer> drawnNumbers = DrawnLotteryNumbersExtensions.draw(max, minVolume, maxVolume);
        return DrawnLotteryNumbers.builder().id(Integer.valueOf(RandomPrimitivesExtensions.randomInt((int)Integer.MAX_VALUE))).lotteryNumbers(drawnNumbers).superNumber(Integer.valueOf(DrawnLotteryNumbersExtensions.drawSuperNumber(drawnNumbers, minVolume, maxVolume))).superSixNumber(Integer.valueOf(RandomPrimitivesExtensions.randomIntBetween((int)1, (int)10))).build();
    }

    public static DrawnLotteryNumbers newRandomDrawnLotteryNumbers(int max, int minVolume, int maxVolume, int drawCount, LotteryAlgorithm algorithm) {
        Objects.requireNonNull(algorithm);
        switch (algorithm) {
            case MAP: {
                DrawnLotteryNumbers drawnLotteryNumbers = DrawnLotteryNumbersFactory.newRandomDrawnLotteryNumbers(max, minVolume, maxVolume);
                drawnLotteryNumbers.setLotteryNumbers(DrawnLotteryNumbersExtensions.drawFromMultiMap(max, minVolume, maxVolume, drawCount));
                return drawnLotteryNumbers;
            }
            case SET: {
                return DrawnLotteryNumbersFactory.newRandomDrawnLotteryNumbers(max, maxVolume);
            }
        }
        return DrawnLotteryNumbersFactory.newRandomDrawnLotteryNumbersDefaultAlgorithm(max, maxVolume);
    }

    public static DrawnLotteryNumbers newRandomDrawnLotteryNumbers(int max, int minVolume, int maxVolume, LotteryAlgorithm algorithm) {
        Objects.requireNonNull(algorithm);
        return DrawnLotteryNumbersFactory.newRandomDrawnLotteryNumbers(max, minVolume, maxVolume, 200, algorithm);
    }

    public static DrawnLotteryNumbers newRandomDrawnLotteryNumbersDefaultAlgorithm(int max, int volume) {
        Set<Integer> lotteryNumbers = DrawnLotteryNumbersExtensions.draw(max, volume);
        int id = RandomPrimitivesExtensions.randomInt((int)Integer.MAX_VALUE);
        int superNumber = DrawnLotteryNumbersExtensions.drawSuperNumber(lotteryNumbers, volume);
        int superSixNumber = RandomPrimitivesExtensions.randomIntBetween((int)1, (int)10);
        return DrawnLotteryNumbers.builder().id(Integer.valueOf(id)).lotteryNumbers(lotteryNumbers).superNumber(Integer.valueOf(superNumber)).superSixNumber(Integer.valueOf(superSixNumber)).build();
    }

    private DrawnLotteryNumbersFactory() {
    }
}

