/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.merge.object;

import de.alpharogroup.copy.object.CopyObjectQuietlyExtensions;
import de.alpharogroup.merge.object.MergeObjectExtensions;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MergeObjectQuietlyExtensions {
    private static final Logger log = LoggerFactory.getLogger(MergeObjectQuietlyExtensions.class);

    public static final <MERGE_IN, WITH> MERGE_IN mergeQuietly(MERGE_IN mergeInObject, WITH withObject) {
        try {
            return MergeObjectExtensions.merge(mergeInObject, withObject);
        }
        catch (InvocationTargetException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        catch (IllegalArgumentException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public static final <MERGE_IN, WITH> MERGE_IN mergeOrCopyQuietly(MERGE_IN mergeInObject, WITH withObject) {
        Object merged = MergeObjectQuietlyExtensions.mergeQuietly(mergeInObject, withObject);
        if (merged == null) {
            merged = CopyObjectQuietlyExtensions.copyQuietly(withObject, mergeInObject);
        }
        return merged;
    }

    private MergeObjectQuietlyExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

