/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.merge.object;

import de.alpharogroup.check.Check;
import de.alpharogroup.lang.ObjectExtensions;
import de.alpharogroup.reflection.ReflectionExtensions;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.PropertyUtils;

public final class MergeObjectExtensions {
    public static final <MERGE_IN, WITH> boolean mergePropertyWithReflection(MERGE_IN mergeInObject, WITH withObject, String fieldName) {
        try {
            ReflectionExtensions.copyFieldValue(withObject, mergeInObject, (String)fieldName);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return false;
        }
        return true;
    }

    public static final <MERGE_IN, WITH> MERGE_IN merge(MERGE_IN mergeInObject, WITH withObject) throws InvocationTargetException, IllegalAccessException {
        PropertyDescriptor[] propertyDescriptors;
        Check.get().notNull(mergeInObject, "mergeInObject").notNull(withObject, "withObject");
        Class<?> toClass = mergeInObject.getClass();
        for (PropertyDescriptor descriptor : propertyDescriptors = PropertyUtils.getPropertyDescriptors(toClass)) {
            MergeObjectExtensions.mergeProperty(mergeInObject, withObject, descriptor);
        }
        return mergeInObject;
    }

    public static final <MERGE_IN, WITH> boolean mergeProperty(MERGE_IN mergeInObject, WITH withObject, PropertyDescriptor propertyDescriptor) throws IllegalAccessException, InvocationTargetException {
        if (PropertyUtils.isReadable(mergeInObject, (String)propertyDescriptor.getName()) && PropertyUtils.isWriteable(mergeInObject, (String)propertyDescriptor.getName())) {
            Method getter = propertyDescriptor.getReadMethod();
            Object value = getter.invoke(withObject, new Object[0]);
            if (!ObjectExtensions.isDefaultValue(propertyDescriptor.getPropertyType(), (Object)value)) {
                Method setter = propertyDescriptor.getWriteMethod();
                setter.invoke(mergeInObject, value);
                return true;
            }
        }
        return false;
    }

    private MergeObjectExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

