/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.merge.object;

import de.alpharogroup.check.Check;
import de.alpharogroup.copy.object.CopyObjectExtensions;
import de.alpharogroup.lang.ObjectExtensions;
import de.alpharogroup.reflection.ReflectionExtensions;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MergeObjectExtensions {
    private static final Logger log = LoggerFactory.getLogger(MergeObjectExtensions.class);

    public static final <MERGE_IN, WITH> boolean mergePropertyWithReflection(MERGE_IN mergeInObject, WITH withObject, String fieldName) {
        try {
            ReflectionExtensions.copyFieldValue(withObject, mergeInObject, (String)fieldName);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            return false;
        }
        return true;
    }

    public static final <MERGE_IN, WITH> MERGE_IN merge(MERGE_IN mergeInObject, WITH withObject) throws InvocationTargetException, IllegalAccessException, IllegalArgumentException {
        PropertyDescriptor[] propertyDescriptors;
        Check.get().notNull(mergeInObject, "mergeInObject").notNull(withObject, "withObject");
        Class<?> toClass = mergeInObject.getClass();
        for (PropertyDescriptor descriptor : propertyDescriptors = PropertyUtils.getPropertyDescriptors(toClass)) {
            MergeObjectExtensions.mergeProperty(mergeInObject, withObject, descriptor);
        }
        return mergeInObject;
    }

    public static final <MERGE_IN, WITH> MERGE_IN mergeQuietly(MERGE_IN mergeInObject, WITH withObject) {
        try {
            return MergeObjectExtensions.merge(mergeInObject, withObject);
        }
        catch (InvocationTargetException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        catch (IllegalArgumentException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public static final <MERGE_IN, WITH> MERGE_IN mergeOrCopyQuietly(MERGE_IN mergeInObject, WITH withObject) {
        Object merged = MergeObjectExtensions.mergeQuietly(mergeInObject, withObject);
        if (merged == null) {
            merged = CopyObjectExtensions.copyQuietly(withObject, mergeInObject);
        }
        return merged;
    }

    public static final <MERGE_IN, WITH> boolean mergeProperty(MERGE_IN mergeInObject, WITH withObject, PropertyDescriptor propertyDescriptor) throws IllegalAccessException, InvocationTargetException, IllegalArgumentException {
        if (PropertyUtils.isReadable(mergeInObject, (String)propertyDescriptor.getName()) && PropertyUtils.isWriteable(mergeInObject, (String)propertyDescriptor.getName())) {
            Method getter = propertyDescriptor.getReadMethod();
            Object value = getter.invoke(withObject, new Object[0]);
            if (!ObjectExtensions.isDefaultValue(propertyDescriptor.getPropertyType(), (Object)value)) {
                Method setter = propertyDescriptor.getWriteMethod();
                setter.invoke(mergeInObject, value);
                return true;
            }
        }
        return false;
    }

    private MergeObjectExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

