/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.merge.api;

import de.alpharogroup.merge.api.Mergeable;
import de.alpharogroup.merge.api.Summarizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public abstract class GenericSummarizer<T extends Mergeable<T>>
implements Summarizer<T> {
    public static final int DEFAULT_MAX_ITERATION = 9999;
    private final int maxIteration;

    public GenericSummarizer() {
        this(9999);
    }

    public GenericSummarizer(int maxIteration) {
        this.maxIteration = maxIteration;
    }

    private List<T> clean(List<T> mergeItems, List<T> toRemove) {
        HashSet<T> set = new HashSet<T>(mergeItems);
        set.removeAll(toRemove);
        return new ArrayList<T>(set);
    }

    @Override
    public List<T> merge(List<T> items) {
        ArrayList toAdd = new ArrayList();
        ArrayList toRemove = new ArrayList();
        this.sort(items);
        List<Object> mergedItems = new ArrayList<T>(items);
        ArrayList<Object> lastIterated = new ArrayList<T>(mergedItems);
        int initialSize = mergedItems.size();
        boolean mergable = true;
        for (int count = 0; mergable && count < this.maxIteration; ++count) {
            this.merge(mergedItems, toAdd, toRemove);
            mergedItems = this.clean(toAdd, toRemove);
            this.sort(mergedItems);
            toAdd.clear();
            toRemove.clear();
            int newSize = mergedItems.size();
            if (initialSize == newSize && mergedItems.equals(lastIterated)) {
                mergable = false;
                break;
            }
            initialSize = newSize;
            lastIterated = new ArrayList<Object>(mergedItems);
        }
        return mergedItems;
    }

    private void merge(List<T> sourceItems, List<T> mergedItems, List<T> toRemove) {
        for (Mergeable clonedT : sourceItems) {
            for (Mergeable section : sourceItems) {
                if (clonedT.equals(section)) {
                    if (mergedItems.contains(section)) continue;
                    mergedItems.add(section);
                    continue;
                }
                Mergeable mergeT = this.merge((T)clonedT, (T)section);
                if (!clonedT.equals(mergeT)) {
                    if (!mergedItems.contains(mergeT)) {
                        mergedItems.add(mergeT);
                    }
                    if (!toRemove.contains(clonedT) && !mergeT.equals(clonedT)) {
                        toRemove.add(clonedT);
                    }
                    if (toRemove.contains(section) || mergeT.equals(section)) continue;
                    toRemove.add(section);
                    continue;
                }
                if (mergedItems.contains(section)) continue;
                mergedItems.add(section);
            }
        }
    }

    protected void sort(List<T> list) {
        Collections.sort(list, this.newComparator());
    }

    protected abstract Comparator<T> newComparator();

    @Override
    public T merge(T object, T other) {
        return (T)((Mergeable)object.merge(other));
    }

    public int getMaxIteration() {
        return this.maxIteration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericSummarizer)) {
            return false;
        }
        GenericSummarizer other = (GenericSummarizer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getMaxIteration() == other.getMaxIteration();
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenericSummarizer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxIteration();
        return result;
    }

    public String toString() {
        return "GenericSummarizer(maxIteration=" + this.getMaxIteration() + ")";
    }
}

