/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.evaluate.object.evaluators;

import de.alpharogroup.clone.object.CloneObjectQuietlyExtensions;
import de.alpharogroup.evaluate.object.evaluators.EqualsEvaluator;
import de.alpharogroup.evaluate.object.evaluators.HashcodeEvaluator;
import de.alpharogroup.evaluate.object.evaluators.ToStringEvaluator;
import io.github.benas.randombeans.api.EnhancedRandom;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EqualsHashCodeAndToStringEvaluator {
    private static final Logger log = LoggerFactory.getLogger(EqualsHashCodeAndToStringEvaluator.class);

    public static <T> boolean evaluateEqualsAndHashcode(T first, T second, T third, T fourth) {
        boolean evaluated = true;
        if (first == null) {
            log.error("first argument is null");
            return false;
        }
        if (first.equals(second)) {
            log.error("first argument equals second argument");
            return false;
        }
        if (!first.equals(third)) {
            log.error("first argument equals third argument");
            return false;
        }
        if (!EqualsEvaluator.evaluateReflexivityNonNullSymmetricAndConsistency(first, second)) {
            return false;
        }
        if (!EqualsEvaluator.evaluateReflexivityNonNullSymmetricConsistencyAndTransitivity(first, third, fourth)) {
            return false;
        }
        if (!HashcodeEvaluator.evaluateEquality(first, fourth)) {
            return false;
        }
        if (!HashcodeEvaluator.evaluateUnequality(first, second)) {
            return false;
        }
        return HashcodeEvaluator.evaluateConsistency(first);
    }

    public static <T> boolean evaluateEqualsAndHashcodeEquality(T object, T otherObject) {
        boolean evaluated = EqualsEvaluator.evaluateReflexivityNonNullSymmetricAndConsistency(object, otherObject);
        if (!evaluated) {
            return false;
        }
        evaluated = HashcodeEvaluator.evaluateEquality(object, otherObject);
        if (!evaluated) {
            return false;
        }
        return evaluated;
    }

    public static <T> boolean evaluateEqualsAndHashcodeUnequality(T object, T otherObject) {
        boolean evaluated = EqualsEvaluator.evaluateReflexivityNonNullSymmetricAndConsistency(object, otherObject);
        if (!evaluated) {
            return false;
        }
        evaluated = HashcodeEvaluator.evaluateUnequality(object, otherObject);
        if (!evaluated) {
            return false;
        }
        return evaluated;
    }

    public static <T> boolean evaluateEqualsHashcodeAndToString(Class<T> cls) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, IOException {
        return EqualsHashCodeAndToStringEvaluator.evaluateEqualsHashcodeAndToString(cls, x$0 -> EnhancedRandom.random((Class)x$0, (String[])new String[0]));
    }

    public static <T> boolean evaluateEqualsHashcodeAndToString(Class<T> cls, Function<Class<T>, T> function) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, IOException {
        if (cls == null) {
            log.error("evaluation of all contract conditions failed because the given class object is null");
            return false;
        }
        T first = function.apply(cls);
        T second = function.apply(cls);
        Object third = CloneObjectQuietlyExtensions.cloneObjectQuietly(first);
        Object fourth = CloneObjectQuietlyExtensions.cloneObjectQuietly((Object)third);
        return EqualsHashCodeAndToStringEvaluator.evaluateEqualsHashcodeAndToString(first, second, third, fourth);
    }

    public static <T> boolean evaluateEqualsHashcodeAndToString(T object) {
        boolean evaluated = EqualsEvaluator.evaluateReflexivityAndNonNull(object);
        if (!evaluated) {
            return false;
        }
        evaluated = HashcodeEvaluator.evaluateConsistency(object);
        if (!evaluated) {
            return false;
        }
        evaluated = ToStringEvaluator.evaluateConsistency(object);
        if (!evaluated) {
            return false;
        }
        return evaluated;
    }

    public static <T> boolean evaluateEqualsHashcodeAndToString(T first, T second, T third, T fourth) {
        boolean evaluated = EqualsHashCodeAndToStringEvaluator.evaluateEqualsAndHashcode(first, second, third, fourth);
        if (!evaluated) {
            return false;
        }
        if (!ToStringEvaluator.evaluate(first.getClass())) {
            return false;
        }
        if (!ToStringEvaluator.evaluateConsistency(first)) {
            return false;
        }
        return evaluated;
    }

    public static <T> boolean evaluateEqualsHashcodeEqualityAndToString(T object, T otherObject, T anotherObject) {
        boolean evaluated = ToStringEvaluator.evaluateConsistency(object);
        if (!evaluated) {
            return false;
        }
        evaluated = HashcodeEvaluator.evaluateConsistency(object);
        if (!evaluated) {
            return false;
        }
        evaluated = HashcodeEvaluator.evaluateEquality(object, otherObject);
        if (!evaluated) {
            return false;
        }
        evaluated = EqualsEvaluator.evaluateReflexivityNonNullSymmetricConsistencyAndTransitivity(otherObject, otherObject, anotherObject);
        if (!evaluated) {
            return false;
        }
        return evaluated;
    }

    private EqualsHashCodeAndToStringEvaluator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

