/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.evaluate.object.checkers;

import de.alpharogroup.evaluate.object.api.ContractViolation;
import de.alpharogroup.evaluate.object.enums.ToStringContractViolation;
import java.util.Optional;

public final class ToStringCheck {
    public static Optional<ContractViolation> evaluate(Class<?> clazz) {
        if (clazz == null) {
            return Optional.of(ToStringContractViolation.CLASS_NULL_ARGUMENT);
        }
        try {
            clazz.getDeclaredMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return Optional.of(ToStringContractViolation.NOT_EXISTENT);
        }
        return Optional.empty();
    }

    public static <T> Optional<ContractViolation> consistency(T object) {
        return ToStringCheck.consistency(object, 7);
    }

    public static <T> Optional<ContractViolation> consistency(T object, int iterations) {
        if (object == null) {
            return Optional.of(ToStringContractViolation.CONSISTENCY_NULL_ARGUMENT);
        }
        String initialToStringResult = object.toString();
        for (int i = 0; i < iterations; ++i) {
            String currentToStringResult = object.toString();
            if (initialToStringResult.equals(currentToStringResult)) continue;
            return Optional.of(ToStringContractViolation.CONSISTENCY);
        }
        return Optional.empty();
    }

    private ToStringCheck() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

