/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.evaluate.object.evaluators;

import de.alpharogroup.evaluate.object.checkers.HashcodeCheck;

public final class HashcodeEvaluator {
    public static <T> boolean evaluateConsistency(T object) {
        return !HashcodeCheck.consistency(object).isPresent();
    }

    public static <T> boolean evaluateEquality(T object, T anotherObject) {
        return !HashcodeCheck.equality(object, anotherObject).isPresent();
    }

    public static <T> boolean evaluateUnequality(T object, T anotherObject) {
        return !HashcodeCheck.unequality(object, anotherObject).isPresent();
    }

    private HashcodeEvaluator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

