/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.evaluate.object.evaluators;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ToStringEvaluator {
    private static final Logger log = LoggerFactory.getLogger(ToStringEvaluator.class);

    public static boolean evaluate(Class<?> clazz) {
        if (clazz == null) {
            log.error("evaluation of toString method failed because the given class object is null");
            return false;
        }
        try {
            clazz.getDeclaredMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            log.error("evaluation of toString method failed because it does not exists.", (Throwable)ex);
            return false;
        }
        return true;
    }

    public static <T> boolean evaluateConsistency(T object) {
        return ToStringEvaluator.evaluateConsistency(object, 7);
    }

    public static <T> boolean evaluateConsistency(T object, int iterations) {
        if (object == null) {
            log.error("evaluation of toString method consistency failed because the first given object is null");
            return false;
        }
        String initialToStringResult = object.toString();
        boolean valid = true;
        for (int i = 0; i < iterations; ++i) {
            String currentToStringResult = object.toString();
            if (initialToStringResult.equals(currentToStringResult)) continue;
            log.error("evaluation of toString method consistency failed on iteration " + i);
            return false;
        }
        return valid;
    }

    private ToStringEvaluator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

