/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.evaluate.object.evaluators;

import de.alpharogroup.clone.object.CloneObjectQuietlyExtensions;
import de.alpharogroup.evaluate.object.api.ContractViolation;
import de.alpharogroup.evaluate.object.checkers.EqualsHashCodeAndToStringCheck;
import de.alpharogroup.evaluate.object.evaluators.EqualsEvaluator;
import de.alpharogroup.evaluate.object.evaluators.HashcodeEvaluator;
import io.github.benas.randombeans.api.EnhancedRandom;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EqualsHashCodeAndToStringEvaluator {
    private static final Logger log = LoggerFactory.getLogger(EqualsHashCodeAndToStringEvaluator.class);

    public static <T> boolean evaluateEqualsAndHashcode(T first, T second, T third, T fourth) {
        Optional<ContractViolation> contractViolation = EqualsHashCodeAndToStringCheck.equalsAndHashcode(first, second, third, fourth);
        return !contractViolation.isPresent();
    }

    public static <T> boolean evaluateEqualsAndHashcodeEquality(T object, T otherObject) {
        boolean evaluated = EqualsEvaluator.evaluateReflexivityNonNullSymmetricAndConsistency(object, otherObject);
        if (!evaluated) {
            return false;
        }
        evaluated = HashcodeEvaluator.evaluateEquality(object, otherObject);
        return evaluated;
    }

    public static <T> boolean evaluateEqualsAndHashcodeUnequality(T object, T otherObject) {
        boolean evaluated = EqualsEvaluator.evaluateReflexivityNonNullSymmetricAndConsistency(object, otherObject);
        if (!evaluated) {
            return false;
        }
        evaluated = HashcodeEvaluator.evaluateUnequality(object, otherObject);
        return evaluated;
    }

    public static <T> boolean evaluateEqualsHashcodeAndToString(Class<T> cls) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, IOException {
        return EqualsHashCodeAndToStringEvaluator.evaluateEqualsHashcodeAndToString(cls, x$0 -> EnhancedRandom.random((Class)x$0, (String[])new String[0]));
    }

    public static <T> boolean evaluateEqualsHashcodeAndToString(Class<T> cls, Function<Class<T>, T> function) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, IOException {
        if (cls == null) {
            log.error("evaluation of all contract conditions failed because the given class object is null");
            return false;
        }
        T first = function.apply(cls);
        T second = function.apply(cls);
        Object third = CloneObjectQuietlyExtensions.cloneObjectQuietly(first);
        Object fourth = CloneObjectQuietlyExtensions.cloneObjectQuietly((Object)third);
        return EqualsHashCodeAndToStringEvaluator.evaluateEqualsHashcodeAndToString(first, second, third, fourth);
    }

    @Deprecated
    public static <T> boolean evaluateEqualsHashcodeAndToString(T object) {
        Optional<ContractViolation> contractViolation = EqualsHashCodeAndToStringCheck.equalsHashcodeAndToString(object);
        return !contractViolation.isPresent();
    }

    public static <T> boolean evaluateEqualsHashcodeAndToString(T first, T second, T third, T fourth) {
        Optional<ContractViolation> contractViolation = EqualsHashCodeAndToStringCheck.equalsHashcodeAndToString(first, second, third, fourth);
        return !contractViolation.isPresent();
    }

    @Deprecated
    public static <T> boolean evaluateEqualsHashcodeEqualityAndToString(T object, T otherObject, T anotherObject) {
        Optional<ContractViolation> contractViolation = EqualsHashCodeAndToStringCheck.equalsHashcodeEqualityAndToString(object, otherObject, anotherObject);
        return !contractViolation.isPresent();
    }

    private EqualsHashCodeAndToStringEvaluator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

