/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.evaluate.object;

public final class EqualsEvaluator {
    public static <T> boolean evaluateReflexivity(T object) {
        if (object == null) {
            return false;
        }
        return object.equals(object);
    }

    public static <T> boolean evaluateSymmetric(T object, T anotherObject) {
        boolean odd;
        if (object == null || anotherObject == null) {
            return false;
        }
        boolean even = object.equals(anotherObject);
        return even == (odd = anotherObject.equals(object));
    }

    public static <T> boolean evaluateTransitivity(T a, T b, T c) {
        if (a == null || b == null) {
            return false;
        }
        boolean aEqualsB = a.equals(b);
        boolean bEqualsC = b.equals(c);
        boolean aEqualsC = a.equals(c);
        return aEqualsB && bEqualsC && aEqualsC;
    }

    public static <T> boolean evaluateNonNull(T object) {
        if (object == null) {
            return false;
        }
        boolean result = !object.equals(null);
        return result;
    }

    public static <T> boolean evaluateConsistency(T object, T anotherObject) {
        return EqualsEvaluator.evaluateConsistency(object, anotherObject, 7);
    }

    public static <T> boolean evaluateConsistency(T object, T anotherObject, int iterations) {
        if (object == null || anotherObject == null) {
            return false;
        }
        boolean initialEqualsResult = object.equals(anotherObject);
        boolean valid = true;
        for (int i = 0; i < iterations; ++i) {
            boolean currentEqualsResult = object.equals(anotherObject);
            if (initialEqualsResult == currentEqualsResult) continue;
            return false;
        }
        return valid;
    }

    public static <T> boolean evaluateReflexivityAndNonNull(T object) {
        boolean evaluated = EqualsEvaluator.evaluateReflexivity(object);
        if (!evaluated) {
            return false;
        }
        evaluated = EqualsEvaluator.evaluateNonNull(object);
        if (!evaluated) {
            return false;
        }
        return evaluated;
    }

    public static <T> boolean evaluateSymmetricAndConsistency(T object, T anotherObject) {
        boolean evaluated = EqualsEvaluator.evaluateSymmetric(object, anotherObject);
        if (!evaluated) {
            return false;
        }
        evaluated = EqualsEvaluator.evaluateConsistency(object, anotherObject);
        if (!evaluated) {
            return false;
        }
        return evaluated;
    }

    public static <T> boolean evaluateReflexivityNonNullSymmetricAndConsistency(T object, T otherObject) {
        boolean evaluated = EqualsEvaluator.evaluateReflexivityAndNonNull(object);
        if (!evaluated) {
            return false;
        }
        evaluated = EqualsEvaluator.evaluateSymmetricAndConsistency(object, otherObject);
        if (!evaluated) {
            return false;
        }
        return evaluated;
    }

    public static <T> boolean evaluateReflexivityNonNullSymmetricConsistencyAndTransitivity(T object, T otherObject, T anotherObject) {
        boolean evaluated = EqualsEvaluator.evaluateReflexivityNonNullSymmetricAndConsistency(otherObject, otherObject);
        if (!evaluated) {
            return false;
        }
        evaluated = EqualsEvaluator.evaluateTransitivity(object, otherObject, anotherObject);
        if (!evaluated) {
            return false;
        }
        return evaluated;
    }

    private EqualsEvaluator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

