/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.evaluate.object.evaluators;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HashcodeEvaluator {
    private static final Logger log = LoggerFactory.getLogger(HashcodeEvaluator.class);

    public static <T> boolean evaluateConsistency(T object) {
        if (object == null) {
            log.error("evaluation of contract condition consistency in hashCode method failed because the given objects is null");
            return false;
        }
        return object.hashCode() == object.hashCode();
    }

    public static <T> boolean evaluateEquality(T object, T anotherObject) {
        if (object == null) {
            log.error("evaluation of contract condition equality in hashCode method failed because the first given objects is null");
            return false;
        }
        if (object.equals(anotherObject)) {
            return object.hashCode() == anotherObject.hashCode();
        }
        throw new IllegalArgumentException("Given arguments should be equal for evaluate equality of hash code");
    }

    public static <T> boolean evaluateUnequality(T object, T anotherObject) {
        if (object == null) {
            log.error("evaluation of contract condition unequality in hashCode method failed because the first given objects is null");
            return false;
        }
        if (!object.equals(anotherObject)) {
            if (anotherObject == null) {
                return true;
            }
            return object.hashCode() != anotherObject.hashCode();
        }
        throw new IllegalArgumentException("Given arguments should be unequal for evaluate unequality of hash code");
    }

    private HashcodeEvaluator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

