/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.evaluate.object.checkers;

import de.alpharogroup.clone.object.CloneObjectQuietlyExtensions;
import de.alpharogroup.evaluate.object.api.ContractViolation;
import de.alpharogroup.evaluate.object.checkers.EqualsCheck;
import de.alpharogroup.evaluate.object.checkers.HashcodeCheck;
import de.alpharogroup.evaluate.object.checkers.ToStringCheck;
import de.alpharogroup.evaluate.object.enums.EqualsHashcodeContractViolation;
import de.alpharogroup.evaluate.object.enums.ToStringContractViolation;
import io.github.benas.randombeans.api.EnhancedRandom;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;

public final class EqualsHashCodeAndToStringCheck {
    public static <T> Optional<ContractViolation> equalsAndHashcode(T first, T second, T third, T fourth) {
        if (first == null) {
            return Optional.of(EqualsHashcodeContractViolation.FIRST_ARG_NULL);
        }
        if (first.equals(second)) {
            return Optional.of(EqualsHashcodeContractViolation.FIRST_AND_SECOND_EQUAL);
        }
        if (!first.equals(third)) {
            return Optional.of(EqualsHashcodeContractViolation.FIRST_AND_THIRD_UNEQUAL);
        }
        Optional<ContractViolation> evaluated = EqualsCheck.reflexivityNonNullSymmetricAndConsistency(first, second);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        evaluated = EqualsCheck.reflexivityNonNullSymmetricConsistencyAndTransitivity(first, third, fourth);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        evaluated = HashcodeCheck.equality(first, fourth);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        evaluated = HashcodeCheck.unequality(first, second);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        evaluated = HashcodeCheck.consistency(first);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        return evaluated;
    }

    public static <T> Optional<ContractViolation> equalsAndHashcodeEquality(T object, T otherObject) {
        Optional<ContractViolation> evaluated = EqualsCheck.reflexivityNonNullSymmetricAndConsistency(object, otherObject);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        evaluated = HashcodeCheck.equality(object, otherObject);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        return evaluated;
    }

    public static <T> Optional<ContractViolation> equalsAndHashcodeUnequality(T object, T otherObject) {
        Optional<ContractViolation> evaluated = EqualsCheck.reflexivityNonNullSymmetricAndConsistency(object, otherObject);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        evaluated = HashcodeCheck.unequality(object, otherObject);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        return evaluated;
    }

    public static <T> Optional<ContractViolation> equalsHashcodeAndToString(Class<T> cls) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, IOException {
        if (cls == null) {
            return Optional.of(ToStringContractViolation.CLASS_NULL_ARGUMENT);
        }
        Object first = EnhancedRandom.random(cls, (String[])new String[0]);
        Object second = EnhancedRandom.random(cls, (String[])new String[0]);
        Object third = CloneObjectQuietlyExtensions.cloneObjectQuietly((Object)first);
        Object fourth = CloneObjectQuietlyExtensions.cloneObjectQuietly((Object)third);
        return EqualsHashCodeAndToStringCheck.equalsHashcodeAndToString(first, second, third, fourth);
    }

    public static <T> Optional<ContractViolation> equalsHashcodeAndToString(T object) {
        Optional<ContractViolation> evaluated = EqualsCheck.reflexivityAndNonNull(object);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        evaluated = HashcodeCheck.consistency(object);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        evaluated = ToStringCheck.consistency(object);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        return evaluated;
    }

    public static <T> Optional<ContractViolation> equalsHashcodeAndToString(T first, T second, T third, T fourth) {
        Optional<ContractViolation> evaluated = EqualsHashCodeAndToStringCheck.equalsAndHashcode(first, second, third, fourth);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        evaluated = ToStringCheck.evaluate(first.getClass());
        if (evaluated.isPresent()) {
            return evaluated;
        }
        evaluated = ToStringCheck.consistency(first);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        return evaluated;
    }

    public static <T> Optional<ContractViolation> equalsHashcodeEqualityAndToString(T object, T otherObject, T anotherObject) {
        Optional<ContractViolation> evaluated = ToStringCheck.consistency(object);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        evaluated = HashcodeCheck.consistency(object);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        evaluated = HashcodeCheck.equality(object, otherObject);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        evaluated = EqualsCheck.reflexivityNonNullSymmetricConsistencyAndTransitivity(otherObject, otherObject, anotherObject);
        if (evaluated.isPresent()) {
            return evaluated;
        }
        return evaluated;
    }

    private EqualsHashCodeAndToStringCheck() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

