/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.evaluate.object;

import de.alpharogroup.clone.object.CloneObjectQuietlyExtensions;
import de.alpharogroup.evaluate.object.EqualsEvaluator;
import de.alpharogroup.evaluate.object.HashcodeEvaluator;
import de.alpharogroup.evaluate.object.ToStringEvaluator;
import io.github.benas.randombeans.api.EnhancedRandom;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

public final class EqualsHashCodeAndToStringEvaluator {
    public static <T> boolean evaluateEqualsAndHashcode(T first, T second, T third, T fourth) {
        boolean evaluated = true;
        if (first == null) {
            return false;
        }
        if (first.equals(second)) {
            return false;
        }
        if (!first.equals(third)) {
            return false;
        }
        if (!EqualsEvaluator.evaluateReflexivityNonNullSymmetricAndConsistency(first, second)) {
            return false;
        }
        if (!EqualsEvaluator.evaluateReflexivityNonNullSymmetricConsistencyAndTransitivity(first, third, fourth)) {
            return false;
        }
        if (!HashcodeEvaluator.evaluateEquality(first, fourth)) {
            return false;
        }
        if (!HashcodeEvaluator.evaluateUnequality(first, second)) {
            return false;
        }
        return HashcodeEvaluator.evaluateConsistency(first);
    }

    public static <T> boolean evaluateEqualsAndHashcodeEquality(T object, T otherObject) {
        boolean evaluated = EqualsEvaluator.evaluateReflexivityNonNullSymmetricAndConsistency(object, otherObject);
        if (!evaluated) {
            return false;
        }
        evaluated = HashcodeEvaluator.evaluateEquality(object, otherObject);
        if (!evaluated) {
            return false;
        }
        return evaluated;
    }

    public static <T> boolean evaluateEqualsAndHashcodeUnequality(T object, T otherObject) {
        boolean evaluated = EqualsEvaluator.evaluateReflexivityNonNullSymmetricAndConsistency(object, otherObject);
        if (!evaluated) {
            return false;
        }
        evaluated = HashcodeEvaluator.evaluateUnequality(object, otherObject);
        if (!evaluated) {
            return false;
        }
        return evaluated;
    }

    public static <T> boolean evaluateEqualsHashcodeAndToString(Class<T> cls) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, IOException {
        if (cls == null) {
            return false;
        }
        Object first = EnhancedRandom.random(cls, (String[])new String[0]);
        Object second = EnhancedRandom.random(cls, (String[])new String[0]);
        Object third = CloneObjectQuietlyExtensions.cloneObjectQuietly((Object)first);
        Object fourth = CloneObjectQuietlyExtensions.cloneObjectQuietly((Object)third);
        return EqualsHashCodeAndToStringEvaluator.evaluateEqualsHashcodeAndToString(first, second, third, fourth);
    }

    public static <T> boolean evaluateEqualsHashcodeAndToString(T object) {
        boolean evaluated = EqualsEvaluator.evaluateReflexivityAndNonNull(object);
        if (!evaluated) {
            return false;
        }
        evaluated = HashcodeEvaluator.evaluateConsistency(object);
        if (!evaluated) {
            return false;
        }
        evaluated = ToStringEvaluator.evaluateConsistency(object);
        if (!evaluated) {
            return false;
        }
        return evaluated;
    }

    public static <T> boolean evaluateEqualsHashcodeAndToString(T first, T second, T third, T fourth) {
        boolean evaluated = EqualsHashCodeAndToStringEvaluator.evaluateEqualsAndHashcode(first, second, third, fourth);
        if (!evaluated) {
            return false;
        }
        if (!ToStringEvaluator.evaluate(first.getClass())) {
            return false;
        }
        if (!ToStringEvaluator.evaluateConsistency(first)) {
            return false;
        }
        return evaluated;
    }

    public static <T> boolean evaluateEqualsHashcodeEqualityAndToString(T object, T otherObject, T anotherObject) {
        boolean evaluated = ToStringEvaluator.evaluateConsistency(object);
        if (!evaluated) {
            return false;
        }
        evaluated = HashcodeEvaluator.evaluateConsistency(object);
        if (!evaluated) {
            return false;
        }
        evaluated = HashcodeEvaluator.evaluateEquality(object, otherObject);
        if (!evaluated) {
            return false;
        }
        evaluated = EqualsEvaluator.evaluateReflexivityNonNullSymmetricConsistencyAndTransitivity(otherObject, otherObject, anotherObject);
        if (!evaluated) {
            return false;
        }
        return evaluated;
    }

    private EqualsHashCodeAndToStringEvaluator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

