/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class ReflectionExtensions {
    public static <T> void copyFieldValue(@NonNull T source, @NonNull T target, @NonNull String fieldName) throws NoSuchFieldException, SecurityException, IllegalAccessException {
        if (source == null) {
            throw new NullPointerException("source is marked @NonNull but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked @NonNull but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked @NonNull but is null");
        }
        Field sourceField = ReflectionExtensions.getDeclaredField(source, fieldName);
        sourceField.setAccessible(true);
        Object sourceValue = sourceField.get(source);
        ReflectionExtensions.setFieldValue(target, fieldName, sourceValue);
    }

    public static <T> void setFieldValue(@NonNull T source, @NonNull String fieldName, Object newValue) throws NoSuchFieldException, SecurityException, IllegalAccessException {
        if (source == null) {
            throw new NullPointerException("source is marked @NonNull but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked @NonNull but is null");
        }
        Field sourceField = ReflectionExtensions.getDeclaredField(source, fieldName);
        sourceField.setAccessible(true);
        sourceField.set(source, newValue);
    }

    public static <T> Object getFieldValue(@NonNull T source, @NonNull String fieldName) throws NoSuchFieldException, SecurityException, IllegalAccessException {
        if (source == null) {
            throw new NullPointerException("source is marked @NonNull but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked @NonNull but is null");
        }
        Field sourceField = ReflectionExtensions.getDeclaredField(source, fieldName);
        sourceField.setAccessible(true);
        return sourceField.get(source);
    }

    public static <T> void setFieldValue(@NonNull Class<?> cls, @NonNull String fieldName, Object newValue) throws NoSuchFieldException, SecurityException, IllegalAccessException {
        if (cls == null) {
            throw new NullPointerException("cls is marked @NonNull but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked @NonNull but is null");
        }
        Field sourceField = ReflectionExtensions.getDeclaredField(cls, fieldName);
        sourceField.setAccessible(true);
        sourceField.set(null, newValue);
    }

    public static List<String> getFieldNames(@NonNull Class<?> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked @NonNull but is null");
        }
        return Arrays.stream(cls.getDeclaredFields()).map(field -> field.getName()).collect(Collectors.toList());
    }

    public static String[] getDeclaredFieldNames(@NonNull Class<?> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked @NonNull but is null");
        }
        return (String[])Arrays.stream(cls.getDeclaredFields()).filter(ReflectionExtensions::isNotSynthetic).map(Field::getName).toArray(String[]::new);
    }

    public static boolean isNotSynthetic(@NonNull Field field) {
        if (field == null) {
            throw new NullPointerException("field is marked @NonNull but is null");
        }
        return !field.isSynthetic();
    }

    public static String[] getMethodNames(@NonNull Class<?> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked @NonNull but is null");
        }
        Method[] methods = cls.getDeclaredMethods();
        String[] methodNames = new String[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            methodNames[i] = methods[i].getName();
        }
        return methodNames;
    }

    public static Map<String, String> getMethodNamesWithPrefixFromFieldNames(@NonNull List<String> fieldNames, String prefix) {
        if (fieldNames == null) {
            throw new NullPointerException("fieldNames is marked @NonNull but is null");
        }
        HashMap<String, String> fieldNameMethodMapper = new HashMap<String, String>();
        for (String fieldName : fieldNames) {
            String firstCharacterToUpperCasefieldName = ReflectionExtensions.firstCharacterToUpperCase(fieldName);
            String methodName = prefix + firstCharacterToUpperCasefieldName;
            fieldNameMethodMapper.put(fieldName, methodName);
        }
        return fieldNameMethodMapper;
    }

    public static String firstCharacterToUpperCase(@NonNull String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked @NonNull but is null");
        }
        String firstCharacter = fieldName.substring(0, 1);
        firstCharacter = firstCharacter.toUpperCase();
        char[] fc = firstCharacter.toCharArray();
        char[] fn = fieldName.toCharArray();
        fn[0] = fc[0];
        return new String(fn);
    }

    public static List<String> getModifiers(@NonNull Field field) {
        if (field == null) {
            throw new NullPointerException("field is marked @NonNull but is null");
        }
        String modifiers = Modifier.toString(field.getModifiers());
        String[] modifiersArray = modifiers.split(" ");
        return Arrays.asList(modifiersArray);
    }

    public static <T> T newInstance(@NonNull T object) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (object == null) {
            throw new NullPointerException("object is marked @NonNull but is null");
        }
        return (T)ReflectionExtensions.newInstance(Class.forName(object.getClass().getCanonicalName()));
    }

    public static <T> T newInstance(@NonNull Class<T> clazz) throws InstantiationException, IllegalAccessException {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked @NonNull but is null");
        }
        return clazz.newInstance();
    }

    public static <T> Field getDeclaredField(@NonNull T object, @NonNull String fieldName) throws NoSuchFieldException, SecurityException {
        if (object == null) {
            throw new NullPointerException("object is marked @NonNull but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked @NonNull but is null");
        }
        return ReflectionExtensions.getDeclaredField(object.getClass(), fieldName);
    }

    public static Field getDeclaredField(@NonNull Class<?> cls, @NonNull String fieldName) throws NoSuchFieldException, SecurityException {
        if (cls == null) {
            throw new NullPointerException("cls is marked @NonNull but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked @NonNull but is null");
        }
        return cls.getDeclaredField(fieldName);
    }

    public static Field[] getAllDeclaredFields(@NonNull Class<?> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked @NonNull but is null");
        }
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(cls.getDeclaredFields()));
        Class<?> superClass = cls.getSuperclass();
        if (superClass != null && superClass.equals(Object.class)) {
            return fields.toArray(new Field[0]);
        }
        while (superClass != null && superClass.getSuperclass() != null && superClass.getSuperclass().equals(Object.class)) {
            fields.addAll(Arrays.asList(superClass.getDeclaredFields()));
            superClass = superClass.getSuperclass();
        }
        return fields.toArray(new Field[0]);
    }

    public static String[] getAllDeclaredFieldNames(@NonNull Class<?> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked @NonNull but is null");
        }
        List<String> fieldNames = Arrays.stream(ReflectionExtensions.getAllDeclaredFields(cls)).map(field -> field.getName()).collect(Collectors.toList());
        return fieldNames.toArray(new String[fieldNames.size()]);
    }

    private ReflectionExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

