/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public final class ReflectionExtensions {
    public static <T> void copyFieldValue(T source, T target, String fieldName) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field sourceField = ReflectionExtensions.getDeclaredField(source, fieldName);
        sourceField.setAccessible(true);
        Object sourceValue = sourceField.get(source);
        ReflectionExtensions.setFieldValue(target, fieldName, sourceValue);
    }

    public static <T> void setFieldValue(T source, String fieldName, Object newValue) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field sourceField = ReflectionExtensions.getDeclaredField(source, fieldName);
        sourceField.setAccessible(true);
        sourceField.set(source, newValue);
    }

    public static <T> Object getFieldValue(T source, String fieldName) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field sourceField = ReflectionExtensions.getDeclaredField(source, fieldName);
        sourceField.setAccessible(true);
        return sourceField.get(source);
    }

    public static <T> void setFieldValue(Class<?> cls, String fieldName, Object newValue) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field sourceField = ReflectionExtensions.getDeclaredField(cls, fieldName);
        sourceField.setAccessible(true);
        sourceField.set(null, newValue);
    }

    public static List<String> getFieldNames(Class<?> cls) {
        Field[] fields = cls.getDeclaredFields();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Field field : fields) {
            fieldNames.add(field.getName());
        }
        return fieldNames;
    }

    public static String[] getMethodNames(Class<?> cls) {
        Method[] methods = cls.getDeclaredMethods();
        String[] methodNames = new String[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            methodNames[i] = methods[i].getName();
        }
        return methodNames;
    }

    public static final Map<String, String> getMethodNamesWithPrefixFromFieldNames(List<String> fieldNames, String prefix) {
        HashMap<String, String> fieldNameMethodMapper = new HashMap<String, String>();
        for (String fieldName : fieldNames) {
            String firstCharacterToUpperCasefieldName = ReflectionExtensions.firstCharacterToUpperCase(fieldName);
            String methodName = prefix + firstCharacterToUpperCasefieldName;
            fieldNameMethodMapper.put(fieldName, methodName);
        }
        return fieldNameMethodMapper;
    }

    public static final String firstCharacterToUpperCase(String fieldName) {
        String firstCharacter = fieldName.substring(0, 1);
        firstCharacter = firstCharacter.toUpperCase();
        char[] fc = firstCharacter.toCharArray();
        char[] fn = fieldName.toCharArray();
        fn[0] = fc[0];
        return new String(fn);
    }

    public static List<String> getModifiers(Field field) {
        String modifiers = Modifier.toString(field.getModifiers());
        String[] modifiersArray = modifiers.split(" ");
        return Arrays.asList(modifiersArray);
    }

    public static <T> T newInstance(T object) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return (T)ReflectionExtensions.newInstance(Class.forName(object.getClass().getCanonicalName()));
    }

    public static <T> T newInstance(Class<T> clazz) throws InstantiationException, IllegalAccessException {
        return clazz.newInstance();
    }

    public static <T> Field getDeclaredField(@NonNull T object, String fieldName) throws NoSuchFieldException, SecurityException {
        if (object == null) {
            throw new NullPointerException("object is marked @NonNull but is null");
        }
        return ReflectionExtensions.getDeclaredField(object.getClass(), fieldName);
    }

    public static Field getDeclaredField(Class<?> cls, String fieldName) throws NoSuchFieldException, SecurityException {
        Field field = cls.getDeclaredField(fieldName);
        return field;
    }

    public static Field[] getAllDeclaredFields(@NonNull Class<?> cls) {
        if (cls == null) {
            throw new NullPointerException("cls is marked @NonNull but is null");
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(cls.getDeclaredFields()));
        Class<?> superClass = cls.getSuperclass();
        if (superClass != null && superClass.equals(Object.class)) {
            return fields.toArray(new Field[0]);
        }
        while (superClass.getSuperclass() != null && superClass.getSuperclass().equals(Object.class)) {
            fields.addAll(Arrays.asList(superClass.getDeclaredFields()));
            superClass = superClass.getSuperclass();
        }
        return fields.toArray(new Field[0]);
    }

    private ReflectionExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

