/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ReflectionExtensions {
    public static <T> void copyFieldValue(T source, T target, String fieldName) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field sourceField = ReflectionExtensions.getDeclaredField(source, fieldName);
        sourceField.setAccessible(true);
        Object sourceValue = sourceField.get(source);
        ReflectionExtensions.setFieldValue(target, fieldName, sourceValue);
    }

    public static <T> void setFieldValue(T source, String fieldName, Object newValue) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field sourceField = ReflectionExtensions.getDeclaredField(source, fieldName);
        sourceField.setAccessible(true);
        sourceField.set(source, newValue);
    }

    public static List<String> getFieldNames(Class<?> cls) {
        Field[] fields = cls.getDeclaredFields();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Field field : fields) {
            fieldNames.add(field.getName());
        }
        return fieldNames;
    }

    public static String[] getMethodNames(Class<?> cls) {
        Method[] methods = cls.getDeclaredMethods();
        String[] methodNames = new String[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            methodNames[i] = methods[i].getName();
        }
        return methodNames;
    }

    public static final Map<String, String> getMethodNamesWithPrefixFromFieldNames(List<String> fieldNames, String prefix) {
        HashMap<String, String> fieldNameMethodMapper = new HashMap<String, String>();
        for (String fieldName : fieldNames) {
            String firstCharacterToUpperCasefieldName = ReflectionExtensions.firstCharacterToUpperCase(fieldName);
            String methodName = prefix + firstCharacterToUpperCasefieldName;
            fieldNameMethodMapper.put(fieldName, methodName);
        }
        return fieldNameMethodMapper;
    }

    public static final String firstCharacterToUpperCase(String fieldName) {
        String firstCharacter = fieldName.substring(0, 1);
        firstCharacter = firstCharacter.toUpperCase();
        char[] fc = firstCharacter.toCharArray();
        char[] fn = fieldName.toCharArray();
        fn[0] = fc[0];
        return new String(fn);
    }

    public static List<String> getModifiers(Field field) {
        String modifiers = Modifier.toString(field.getModifiers());
        String[] modifiersArray = modifiers.split(" ");
        return Arrays.asList(modifiersArray);
    }

    public static <T> T newInstance(T object) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return (T)ReflectionExtensions.newInstance(Class.forName(object.getClass().getCanonicalName()));
    }

    public static <T> T newInstance(Class<T> clazz) throws InstantiationException, IllegalAccessException {
        return clazz.newInstance();
    }

    public static <T> Field getDeclaredField(T object, String fieldName) throws NoSuchFieldException, SecurityException {
        Field field = object.getClass().getDeclaredField(fieldName);
        return field;
    }

    public static Field getDeclaredField(Class<?> cls, String fieldName) throws NoSuchFieldException, SecurityException {
        Field field = cls.getDeclaredField(fieldName);
        return field;
    }

    private ReflectionExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

