/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.lang;

import de.alpharogroup.lang.ClassType;
import de.alpharogroup.lang.DefaultValue;
import java.util.Collection;
import java.util.Map;

public final class ObjectExtensions {
    public static final <T> boolean isDefaultValue(Class<?> fieldClass, T object) {
        if (object == null) {
            return true;
        }
        Object defaultValue = DefaultValue.get(fieldClass);
        if (defaultValue != null) {
            return DefaultValue.get(fieldClass).equals(object);
        }
        return false;
    }

    public static <T> ClassType getClassType(Class<T> clazz) {
        if (clazz == null) {
            return null;
        }
        if (clazz.isArray()) {
            return ClassType.ARRAY;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return ClassType.COLLECTION;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return ClassType.MAP;
        }
        if (clazz.isLocalClass()) {
            return ClassType.LOCAL;
        }
        if (clazz.isMemberClass()) {
            return ClassType.MEMBER;
        }
        if (clazz.isPrimitive()) {
            return ClassType.PRIMITIVE;
        }
        if (clazz.isAnnotation()) {
            return ClassType.ANNOTATION;
        }
        if (clazz.isEnum()) {
            return ClassType.ENUM;
        }
        if (clazz.isInterface()) {
            return ClassType.INTERFACE;
        }
        if (clazz.isSynthetic()) {
            return ClassType.SYNTHETIC;
        }
        if (clazz.isAnonymousClass()) {
            return ClassType.ANONYMOUS;
        }
        return ClassType.DEFAULT;
    }

    private ObjectExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

