/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.check;

import java.util.Collection;
import java.util.Map;

public final class Argument {
    public static <T extends Comparable<? super T>> T isInRange(T min, T max, T value, String name) {
        Argument.notNull(min, "min");
        Argument.notNull(max, "max");
        if (value.compareTo(min) < 0 || value.compareTo(max) > 0) {
            throw new IllegalArgumentException(String.format("Given argument '%s' should have a value between %s - %s, but given argument is currently:%s", name, min, max, value));
        }
        return value;
    }

    public static <T, C extends Collection<T>> C notEmpty(C collection, String name) {
        Argument.notNull(collection, name);
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Given collection '" + name + "' may not be empty.");
        }
        return collection;
    }

    public static <K, V, M extends Map<K, V>> M notEmpty(M map, String name) {
        Argument.notNull(map, name);
        if (map.isEmpty()) {
            throw new IllegalArgumentException("Given map '" + name + "' may not be empty.");
        }
        return map;
    }

    public static <T extends CharSequence> T notEmpty(T argument, String name) {
        Argument.notNull(argument, name);
        if (argument.length() == 0 || argument.toString().trim().length() == 0) {
            throw new IllegalArgumentException("Given argument '" + name + "' may not be empty.");
        }
        return argument;
    }

    public static <T> T notNull(T argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException("Given argument '" + name + "' may not be null.");
        }
        return argument;
    }

    private Argument() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

