/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.copy.object;

import de.alpharogroup.lang.ClassType;
import de.alpharogroup.lang.ObjectExtensions;
import de.alpharogroup.reflection.ReflectionExtensions;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import lombok.NonNull;
import org.apache.commons.beanutils.BeanUtils;

public final class CopyObjectExtensions {
    public static <T> T copyObject(@NonNull T original) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (original == null) {
            throw new NullPointerException("original is marked @NonNull but is null");
        }
        Class<?> clazz = original.getClass();
        Object destination = ReflectionExtensions.newInstanceWithObjenesis(clazz);
        return (T)CopyObjectExtensions.copyObject(original, destination, new String[0]);
    }

    public static <ORIGINAL, DESTINATION> DESTINATION copyObject(@NonNull ORIGINAL original, @NonNull DESTINATION destination, String ... ignoreFieldNames) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Field[] allDeclaredFields;
        if (original == null) {
            throw new NullPointerException("original is marked @NonNull but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked @NonNull but is null");
        }
        for (Field field : allDeclaredFields = ReflectionExtensions.getAllDeclaredFields(original.getClass(), (String[])ignoreFieldNames)) {
            if (!Arrays.asList(ignoreFieldNames).contains(field.getName()) && !CopyObjectExtensions.copyField(field, original, destination)) continue;
        }
        return destination;
    }

    public static <ORIGINAL, DESTINATION> boolean copyField(@NonNull Field field, @NonNull ORIGINAL original, @NonNull DESTINATION destination) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (field == null) {
            throw new NullPointerException("field is marked @NonNull but is null");
        }
        if (original == null) {
            throw new NullPointerException("original is marked @NonNull but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked @NonNull but is null");
        }
        field.setAccessible(true);
        Object value = field.get(original);
        if (value == null || Modifier.isFinal(field.getModifiers())) {
            return true;
        }
        Class<?> fieldType = field.getType();
        ClassType classType = ObjectExtensions.getClassType(fieldType);
        switch (classType) {
            case ARRAY: {
                Class<?> arrayType = value.getClass().getComponentType();
                Object dest = Array.newInstance(arrayType, Array.getLength(value));
                for (int i = 0; i < Array.getLength(value); ++i) {
                    Array.set(destination, i, Array.get(value, i));
                }
                field.set(destination, dest);
                break;
            }
            case ENUM: {
                Enum enumValue = (Enum)value;
                String name = enumValue.name();
                field.set(destination, Enum.valueOf(fieldType.asSubclass(Enum.class), name));
                break;
            }
            case ANNOTATION: 
            case ANONYMOUS: 
            case COLLECTION: 
            case LOCAL: 
            case DEFAULT: 
            case MEMBER: 
            case SYNTHETIC: 
            case INTERFACE: 
            case PRIMITIVE: {
                field.set(destination, value);
                break;
            }
            case MAP: {
                field.set(destination, value);
            }
        }
        return false;
    }

    public static <T> T copyPropertiesWithReflection(@NonNull T original, String ... ignoreFieldNames) throws InstantiationException, IllegalAccessException, NoSuchFieldException {
        String[] allDeclaredFieldNames;
        if (original == null) {
            throw new NullPointerException("original is marked @NonNull but is null");
        }
        Class<?> clazz = original.getClass();
        Object destination = ReflectionExtensions.newInstanceWithObjenesis(clazz);
        for (String fieldName : allDeclaredFieldNames = ReflectionExtensions.getAllDeclaredFieldNames(clazz, (String[])ignoreFieldNames)) {
            ReflectionExtensions.copyFieldValue(original, (Object)destination, (String)fieldName);
        }
        return (T)destination;
    }

    public static <ORIGINAL, DESTINATION> DESTINATION copyPropertyWithReflection(@NonNull ORIGINAL original, @NonNull DESTINATION destination, @NonNull String fieldName) throws NoSuchFieldException, SecurityException, IllegalAccessException {
        if (original == null) {
            throw new NullPointerException("original is marked @NonNull but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked @NonNull but is null");
        }
        if (fieldName == null) {
            throw new NullPointerException("fieldName is marked @NonNull but is null");
        }
        ReflectionExtensions.copyFieldValue(original, destination, (String)fieldName);
        return destination;
    }

    public static <ORIGINAL, DESTINATION> DESTINATION copy(@NonNull ORIGINAL original, @NonNull DESTINATION destination) throws IllegalAccessException, InvocationTargetException, IllegalArgumentException {
        if (original == null) {
            throw new NullPointerException("original is marked @NonNull but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked @NonNull but is null");
        }
        return CopyObjectExtensions.copyProperties(original, destination);
    }

    public static <ORIGINAL, DESTINATION> DESTINATION copyProperties(@NonNull ORIGINAL original, @NonNull DESTINATION destination) throws IllegalAccessException, InvocationTargetException {
        if (original == null) {
            throw new NullPointerException("original is marked @NonNull but is null");
        }
        if (destination == null) {
            throw new NullPointerException("destination is marked @NonNull but is null");
        }
        BeanUtils.copyProperties(destination, original);
        return destination;
    }

    public static <T> T copyProperties(@NonNull T original) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        if (original == null) {
            throw new NullPointerException("original is marked @NonNull but is null");
        }
        Class<?> clazz = original.getClass();
        Object destination = ReflectionExtensions.newInstanceWithObjenesis(clazz);
        BeanUtils.copyProperties((Object)destination, original);
        return (T)destination;
    }

    /*
     * Exception decompiling
     */
    public static <T extends Serializable> T copySerializedObject(@NonNull T orig) throws IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CopyObjectExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

