/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.copy.object;

import de.alpharogroup.copy.object.CopyObjectExtensions;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CopyObjectQuietlyExtensions {
    private static final Logger log = LoggerFactory.getLogger(CopyObjectQuietlyExtensions.class);

    public static final <ORIGINAL, DESTINATION> DESTINATION copyQuietly(ORIGINAL original, DESTINATION destination) {
        try {
            return CopyObjectExtensions.copy(original, destination);
        }
        catch (IllegalAccessException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        catch (IllegalArgumentException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public static final <DESTINATION, ORIGINAL> boolean isCopyable(ORIGINAL original, DESTINATION destination) {
        return CopyObjectQuietlyExtensions.copyQuietly(original, destination) != null;
    }

    public static final <ORIGINAL, DESTINATION> DESTINATION copyPropertiesQuietly(ORIGINAL original, DESTINATION destination) {
        try {
            CopyObjectExtensions.copyProperties(original, destination);
            return destination;
        }
        catch (IllegalAccessException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }

    public static boolean closeOutputStream(OutputStream out) {
        boolean closed = true;
        try {
            if (out != null) {
                out.flush();
                out.close();
                out = null;
            }
        }
        catch (IOException e) {
            closed = false;
        }
        finally {
            try {
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (IOException e) {
                closed = false;
            }
        }
        return closed;
    }

    private CopyObjectQuietlyExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

