/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.copy.object;

import de.alpharogroup.reflection.ReflectionExtensions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CopyObjectExtensions {
    private static final Logger log = LoggerFactory.getLogger(CopyObjectExtensions.class);

    public static final <ORIGINAL, DESTINATION> DESTINATION copyPropertyWithReflection(ORIGINAL original, DESTINATION destination, String fieldName) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        ReflectionExtensions.copyFieldValue(original, destination, (String)fieldName);
        return destination;
    }

    public static final <ORIGINAL, DESTINATION> DESTINATION copy(ORIGINAL original, DESTINATION destination) throws IllegalAccessException, InvocationTargetException, IllegalArgumentException {
        BeanUtils.copyProperties(destination, original);
        return destination;
    }

    public static final <ORIGINAL, DESTINATION> DESTINATION copyQuietly(ORIGINAL original, DESTINATION destination) {
        try {
            return CopyObjectExtensions.copy(original, destination);
        }
        catch (IllegalAccessException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        catch (IllegalArgumentException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public static final <DESTINATION, ORIGINAL> boolean isCopyable(ORIGINAL original, DESTINATION destination) {
        return CopyObjectExtensions.copyQuietly(original, destination) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> T copySerializedObject(T orig) throws IOException, ClassNotFoundException {
        Serializable object = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(orig);
            objectOutputStream.flush();
            objectOutputStream.close();
            ByteArrayInputStream bis = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bis);
            object = (Serializable)ois.readObject();
        }
        catch (Throwable throwable) {
            CopyObjectExtensions.closeOutputStream(byteArrayOutputStream);
            CopyObjectExtensions.closeOutputStream(objectOutputStream);
            throw throwable;
        }
        CopyObjectExtensions.closeOutputStream(byteArrayOutputStream);
        CopyObjectExtensions.closeOutputStream(objectOutputStream);
        return (T)object;
    }

    public static boolean closeOutputStream(OutputStream out) {
        boolean closed = true;
        try {
            if (out != null) {
                out.flush();
                out.close();
                out = null;
            }
        }
        catch (IOException e) {
            closed = false;
        }
        finally {
            try {
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (IOException e) {
                closed = false;
            }
        }
        return closed;
    }

    private CopyObjectExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

