/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.copy.object;

import de.alpharogroup.copy.object.CopyObjectExtensions;
import de.alpharogroup.reflection.ReflectionExtensions;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CopyObjectQuietlyExtensions {
    private static final Logger log = LoggerFactory.getLogger(CopyObjectQuietlyExtensions.class);

    public static final <ORIGINAL, DESTINATION> DESTINATION copyPropertyWithReflectionQuietly(ORIGINAL original, DESTINATION destination, String fieldName) {
        try {
            ReflectionExtensions.copyFieldValue(original, destination, (String)fieldName);
        }
        catch (NoSuchFieldException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (SecurityException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return destination;
    }

    public static final <ORIGINAL, DESTINATION> DESTINATION copyQuietly(ORIGINAL original, DESTINATION destination) {
        try {
            return CopyObjectExtensions.copy(original, destination);
        }
        catch (IllegalAccessException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }

    public static final <DESTINATION, ORIGINAL> boolean isCopyable(ORIGINAL original, DESTINATION destination) {
        return CopyObjectQuietlyExtensions.copyQuietly(original, destination) != null;
    }

    public static final <ORIGINAL, DESTINATION> DESTINATION copyPropertiesQuietly(ORIGINAL original, DESTINATION destination) {
        try {
            CopyObjectExtensions.copyProperties(original, destination);
            return destination;
        }
        catch (IllegalAccessException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }

    public static final <T> T copyPropertiesQuietly(T original) {
        T destination = null;
        try {
            destination = CopyObjectExtensions.copyProperties(original);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return destination;
    }

    public static <T extends Serializable> T copySerializedObjectQuietly(T orig) {
        try {
            T serializedObject = CopyObjectExtensions.copySerializedObject(orig);
            return serializedObject;
        }
        catch (ClassNotFoundException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IOException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }

    private CopyObjectQuietlyExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

