/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.copy.object;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CopyObjectExtensions {
    private static final Logger log = LoggerFactory.getLogger(CopyObjectExtensions.class);

    public static final <ORIGINAL, DESTINATION> DESTINATION copyPropertyWithReflection(ORIGINAL original, DESTINATION destination, String fieldName) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        CopyObjectExtensions.copyFieldValue(original, destination, fieldName);
        return destination;
    }

    public static <T> void copyFieldValue(T source, T target, String fieldName) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field sourceField = CopyObjectExtensions.getDeclaredField(source, fieldName);
        sourceField.setAccessible(true);
        Object sourceValue = sourceField.get(source);
        CopyObjectExtensions.setFieldValue(target, fieldName, sourceValue);
    }

    public static <T> Field getDeclaredField(T object, String fieldName) throws NoSuchFieldException, SecurityException {
        Field field = object.getClass().getDeclaredField(fieldName);
        return field;
    }

    public static <T> void setFieldValue(T source, String fieldName, Object newValue) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field sourceField = CopyObjectExtensions.getDeclaredField(source, fieldName);
        sourceField.setAccessible(true);
        sourceField.set(source, newValue);
    }

    public static final <ORIGINAL, DESTINATION> DESTINATION copy(ORIGINAL original, DESTINATION destination) throws IllegalAccessException, InvocationTargetException, IllegalArgumentException {
        BeanUtils.copyProperties(destination, original);
        return destination;
    }

    public static final <ORIGINAL, DESTINATION> DESTINATION copyQuietly(ORIGINAL original, DESTINATION destination) {
        try {
            return CopyObjectExtensions.copy(original, destination);
        }
        catch (IllegalAccessException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        catch (InvocationTargetException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        catch (IllegalArgumentException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    public static final <DESTINATION, ORIGINAL> boolean isCopyable(ORIGINAL original, DESTINATION destination) {
        return CopyObjectExtensions.copyQuietly(original, destination) != null;
    }

    private CopyObjectExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

