/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.compare.object;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompareObjectQuietlyExtensions {
    private static final Logger log = LoggerFactory.getLogger(CompareObjectQuietlyExtensions.class);

    public static int compareToQuietly(Object sourceOjbect, Object objectToCompare, String property) {
        Map beanDescription = null;
        try {
            beanDescription = BeanUtils.describe((Object)sourceOjbect);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("BeanUtils.describe(sourceOjbect) throws an exception...", (Throwable)e);
            return 0;
        }
        Map clonedBeanDescription = null;
        try {
            clonedBeanDescription = BeanUtils.describe((Object)objectToCompare);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("BeanUtils.describe(objectToCompare) throws an exception...", (Throwable)e);
            return 0;
        }
        Object sourceAttribute = beanDescription.get(property);
        Object changedAttribute = clonedBeanDescription.get(property);
        if (sourceAttribute == null && changedAttribute == null) {
            return 0;
        }
        if (sourceAttribute != null && changedAttribute == null) {
            return 1;
        }
        if (sourceAttribute == null && changedAttribute != null) {
            return -1;
        }
        return new BeanComparator(property).compare(sourceOjbect, objectToCompare);
    }

    private CompareObjectQuietlyExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

