/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.clone.object;

import de.alpharogroup.copy.object.CopyObjectExtensions;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class CloneObjectExtensions {
    public static <T> T clone(T object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException, IOException {
        return (T)CloneObjectExtensions.cloneObject(object);
    }

    public static Object cloneObject(Object object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException, IOException {
        if (object == null) {
            return object;
        }
        Object clone = null;
        if (object instanceof Cloneable) {
            clone = CloneObjectExtensions.cloneCloneable(object);
        }
        if (clone == null && object instanceof Serializable) {
            Serializable serializableObject = (Serializable)object;
            clone = CopyObjectExtensions.copySerializedObject((Serializable)serializableObject);
        }
        if (clone == null) {
            clone = CloneObjectExtensions.cloneBean(object);
        }
        return clone;
    }

    public static Object cloneCloneable(Object object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (object.getClass().isArray()) {
            Object clone;
            Class<?> componentType = object.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                int length = Array.getLength(object);
                clone = Array.newInstance(componentType, length);
                while (length-- > 0) {
                    Array.set(clone, length, Array.get(object, length));
                }
            } else {
                clone = ((Object[])object).clone();
            }
            if (clone != null) {
                return clone;
            }
        }
        Class<?> clazz = object.getClass();
        Method cloneMethod = clazz.getDeclaredMethod("clone", new Class[0]);
        cloneMethod.setAccessible(true);
        return cloneMethod.invoke(object, (Object[])null);
    }

    public static <T> T cloneBean(T object) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        return (T)CopyObjectExtensions.copyObject(object);
    }

    private CloneObjectExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

